// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.NetApp.Models;

namespace Azure.ResourceManager.NetApp
{
    internal class ClusterPeerCommandResultOperationSource : IOperationSource<ClusterPeerCommandResult>
    {
        ClusterPeerCommandResult IOperationSource<ClusterPeerCommandResult>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return ClusterPeerCommandResult.DeserializeClusterPeerCommandResult(document.RootElement);
        }

        async ValueTask<ClusterPeerCommandResult> IOperationSource<ClusterPeerCommandResult>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return ClusterPeerCommandResult.DeserializeClusterPeerCommandResult(document.RootElement);
        }
    }
}
