// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.NetApp
{
    internal class CapacityPoolOperationSource : IOperationSource<CapacityPoolResource>
    {
        private readonly ArmClient _client;

        internal CapacityPoolOperationSource(ArmClient client)
        {
            _client = client;
        }

        CapacityPoolResource IOperationSource<CapacityPoolResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = CapacityPoolData.DeserializeCapacityPoolData(document.RootElement);
            return new CapacityPoolResource(_client, data);
        }

        async ValueTask<CapacityPoolResource> IOperationSource<CapacityPoolResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = CapacityPoolData.DeserializeCapacityPoolData(document.RootElement);
            return new CapacityPoolResource(_client, data);
        }
    }
}
