// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.NetApp.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableNetAppArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableNetAppArmClient"/> class for mocking. </summary>
        protected MockableNetAppArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableNetAppArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableNetAppArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableNetAppArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="RegionInfoResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="RegionInfoResource.CreateResourceIdentifier" /> to create a <see cref="RegionInfoResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="RegionInfoResource"/> object. </returns>
        public virtual RegionInfoResource GetRegionInfoResource(ResourceIdentifier id)
        {
            RegionInfoResource.ValidateResourceId(id);
            return new RegionInfoResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetAppAccountResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetAppAccountResource.CreateResourceIdentifier" /> to create a <see cref="NetAppAccountResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetAppAccountResource"/> object. </returns>
        public virtual NetAppAccountResource GetNetAppAccountResource(ResourceIdentifier id)
        {
            NetAppAccountResource.ValidateResourceId(id);
            return new NetAppAccountResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="CapacityPoolResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="CapacityPoolResource.CreateResourceIdentifier" /> to create a <see cref="CapacityPoolResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="CapacityPoolResource"/> object. </returns>
        public virtual CapacityPoolResource GetCapacityPoolResource(ResourceIdentifier id)
        {
            CapacityPoolResource.ValidateResourceId(id);
            return new CapacityPoolResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetAppVolumeResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetAppVolumeResource.CreateResourceIdentifier" /> to create a <see cref="NetAppVolumeResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetAppVolumeResource"/> object. </returns>
        public virtual NetAppVolumeResource GetNetAppVolumeResource(ResourceIdentifier id)
        {
            NetAppVolumeResource.ValidateResourceId(id);
            return new NetAppVolumeResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetAppVolumeSnapshotResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetAppVolumeSnapshotResource.CreateResourceIdentifier" /> to create a <see cref="NetAppVolumeSnapshotResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetAppVolumeSnapshotResource"/> object. </returns>
        public virtual NetAppVolumeSnapshotResource GetNetAppVolumeSnapshotResource(ResourceIdentifier id)
        {
            NetAppVolumeSnapshotResource.ValidateResourceId(id);
            return new NetAppVolumeSnapshotResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SnapshotPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SnapshotPolicyResource.CreateResourceIdentifier" /> to create a <see cref="SnapshotPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SnapshotPolicyResource"/> object. </returns>
        public virtual SnapshotPolicyResource GetSnapshotPolicyResource(ResourceIdentifier id)
        {
            SnapshotPolicyResource.ValidateResourceId(id);
            return new SnapshotPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetAppBackupPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetAppBackupPolicyResource.CreateResourceIdentifier" /> to create a <see cref="NetAppBackupPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetAppBackupPolicyResource"/> object. </returns>
        public virtual NetAppBackupPolicyResource GetNetAppBackupPolicyResource(ResourceIdentifier id)
        {
            NetAppBackupPolicyResource.ValidateResourceId(id);
            return new NetAppBackupPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetAppVolumeQuotaRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetAppVolumeQuotaRuleResource.CreateResourceIdentifier" /> to create a <see cref="NetAppVolumeQuotaRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetAppVolumeQuotaRuleResource"/> object. </returns>
        public virtual NetAppVolumeQuotaRuleResource GetNetAppVolumeQuotaRuleResource(ResourceIdentifier id)
        {
            NetAppVolumeQuotaRuleResource.ValidateResourceId(id);
            return new NetAppVolumeQuotaRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetAppVolumeGroupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetAppVolumeGroupResource.CreateResourceIdentifier" /> to create a <see cref="NetAppVolumeGroupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetAppVolumeGroupResource"/> object. </returns>
        public virtual NetAppVolumeGroupResource GetNetAppVolumeGroupResource(ResourceIdentifier id)
        {
            NetAppVolumeGroupResource.ValidateResourceId(id);
            return new NetAppVolumeGroupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetAppSubvolumeInfoResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetAppSubvolumeInfoResource.CreateResourceIdentifier" /> to create a <see cref="NetAppSubvolumeInfoResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetAppSubvolumeInfoResource"/> object. </returns>
        public virtual NetAppSubvolumeInfoResource GetNetAppSubvolumeInfoResource(ResourceIdentifier id)
        {
            NetAppSubvolumeInfoResource.ValidateResourceId(id);
            return new NetAppSubvolumeInfoResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetAppBackupVaultBackupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetAppBackupVaultBackupResource.CreateResourceIdentifier" /> to create a <see cref="NetAppBackupVaultBackupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetAppBackupVaultBackupResource"/> object. </returns>
        public virtual NetAppBackupVaultBackupResource GetNetAppBackupVaultBackupResource(ResourceIdentifier id)
        {
            NetAppBackupVaultBackupResource.ValidateResourceId(id);
            return new NetAppBackupVaultBackupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetAppBackupVaultResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetAppBackupVaultResource.CreateResourceIdentifier" /> to create a <see cref="NetAppBackupVaultResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetAppBackupVaultResource"/> object. </returns>
        public virtual NetAppBackupVaultResource GetNetAppBackupVaultResource(ResourceIdentifier id)
        {
            NetAppBackupVaultResource.ValidateResourceId(id);
            return new NetAppBackupVaultResource(Client, id);
        }
    }
}
