﻿// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

//#nullable disable

//using System;
//using System.ClientModel.Primitives;
//using System.Collections.Generic;
//using System.Text.Json;
//using Azure.Core;

//namespace Azure.ResourceManager.NetApp.Models
//{
//    public partial class NetAppVolumeBackupConfiguration : IUtf8JsonSerializable, IJsonModel<NetAppVolumeBackupConfiguration>
//    {
//        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<NetAppAccountData>)this).Write(writer, new ModelReaderWriterOptions("W"));

//        void IJsonModel<NetAppVolumeBackupConfiguration>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
//        {
//            var format = options.Format == "W" ? ((IPersistableModel<NetAppVolumeDataProtection>)this).GetFormatFromOptions(options) : options.Format;
//            if (format != "J")
//            {
//                throw new FormatException($"The model {nameof(NetAppVolumeDataProtection)} does not support '{format}' format.");
//            }

//            writer.WriteStartObject();
//            if (Optional.IsDefined(BackupPolicyId))
//            {
//                writer.WritePropertyName("backupPolicyId");
//                writer.WriteStringValue(BackupPolicyId);
//            }
//            if (Optional.IsDefined(IsPolicyEnforced))
//            {
//                writer.WritePropertyName("policyEnforced");
//                writer.WriteBooleanValue(IsPolicyEnforced.Value);
//            }
//            if (Optional.IsDefined(VaultId))
//            {
//                writer.WritePropertyName("vaultId");
//                writer.WriteStringValue(VaultId);
//            }
//            if (Optional.IsDefined(IsBackupEnabled))
//            {
//                writer.WritePropertyName("backupEnabled");
//                writer.WriteBooleanValue(IsBackupEnabled.Value);
//            }
//            if (options.Format != "W" && _serializedAdditionalRawData != null)
//            {
//                foreach (var item in _serializedAdditionalRawData)
//                {
//                    writer.WritePropertyName(item.Key);
//#if NET6_0_OR_GREATER
//				writer.WriteRawValue(item.Value);
//#else
//                    using (JsonDocument document = JsonDocument.Parse(item.Value))
//                    {
//                        JsonSerializer.Serialize(writer, document.RootElement);
//                    }
//#endif
//                }
//            }
//           writer.WriteEndObject();
//        }

//        internal static NetAppVolumeBackupConfiguration DeserializeNetAppVolumeBackupConfiguration(JsonElement element, ModelReaderWriterOptions options = null)
//        {
//            options ??= new ModelReaderWriterOptions("W");

//            if (element.ValueKind == JsonValueKind.Null)
//            {
//                return null;
//            }
//            ResourceIdentifier backupPolicyId = default;
//            bool policyEnforced = default;
//            bool backupEnabled = default;
//            ResourceIdentifier vaultId = default;
//            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
//            Dictionary<string, BinaryData> additionalPropertiesDictionary = new Dictionary<string, BinaryData>();

//            foreach (var property in element.EnumerateObject())
//            {
//                if (property.NameEquals("backupPolicyId"u8))
//                {
//                    if (property.Value.ValueKind == JsonValueKind.Null)
//                    {
//                        property.ThrowNonNullablePropertyIsNull();
//                        continue;
//                    }
//                    backupPolicyId = new ResourceIdentifier(property.Value.GetString());
//                    continue;
//                }
//                if (property.NameEquals("policyEnforced"u8))
//                {
//                    if (property.Value.ValueKind == JsonValueKind.Null)
//                    {
//                        property.ThrowNonNullablePropertyIsNull();
//                        continue;
//                    }
//                    policyEnforced = property.Value.GetBoolean();
//                    continue;
//                }
//                if (property.NameEquals("backupEnabled"u8))
//                {
//                    if (property.Value.ValueKind == JsonValueKind.Null)
//                    {
//                        property.ThrowNonNullablePropertyIsNull();
//                        continue;
//                    }
//                    backupEnabled = property.Value.GetBoolean();
//                    continue;
//                }
//                if (property.NameEquals("vaultId"u8))
//                {
//                    if (property.Value.ValueKind == JsonValueKind.Null)
//                    {
//                        property.ThrowNonNullablePropertyIsNull();
//                        continue;
//                    }
//                    vaultId = new ResourceIdentifier(property.Value.GetString());
//                    continue;
//                }

//                if (options.Format != "W")
//                {
//                    additionalPropertiesDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
//                }
//            }
//            serializedAdditionalRawData = additionalPropertiesDictionary;
//            return new NetAppVolumeBackupConfiguration(backupPolicyId, policyEnforced, vaultId, backupEnabled, serializedAdditionalRawData);
//        }

//        NetAppVolumeBackupConfiguration IJsonModel<NetAppVolumeBackupConfiguration>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
//        {
//            var format = options.Format == "W" ? ((IPersistableModel<NetAppVolumeBackupConfiguration>)this).GetFormatFromOptions(options) : options.Format;
//            if (format != "J")
//            {
//                throw new FormatException($"The model {nameof(NetAppVolumeBackupConfiguration)} does not support '{format}' format.");
//            }

//            using JsonDocument document = JsonDocument.ParseValue(ref reader);
//            return DeserializeNetAppVolumeBackupConfiguration(document.RootElement, options);
//        }

//        BinaryData IPersistableModel<NetAppVolumeBackupConfiguration>.Write(ModelReaderWriterOptions options)
//        {
//            var format = options.Format == "W" ? ((IPersistableModel<NetAppVolumeBackupConfiguration>)this).GetFormatFromOptions(options) : options.Format;

//            switch (format)
//            {
//                case "J":
//                    return ModelReaderWriter.Write(this, options);
//                default:
//                    throw new FormatException($"The model {nameof(NetAppVolumeBackupConfiguration)} does not support '{options.Format}' format.");
//            }
//        }

//        NetAppVolumeBackupConfiguration IPersistableModel<NetAppVolumeBackupConfiguration>.Create(BinaryData data, ModelReaderWriterOptions options)
//        {
//            var format = options.Format == "W" ? ((IPersistableModel<NetAppVolumeBackupConfiguration>)this).GetFormatFromOptions(options) : options.Format;

//            switch (format)
//            {
//                case "J":
//                    {
//                        using JsonDocument document = JsonDocument.Parse(data);
//                        return DeserializeNetAppVolumeBackupConfiguration(document.RootElement, options);
//                    }
//                default:
//                    throw new FormatException($"The model {nameof(NetAppVolumeBackupConfiguration)} does not support '{options.Format}' format.");
//            }
//        }
//        string IPersistableModel<NetAppVolumeBackupConfiguration>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
//    }
//}
