﻿// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

//#nullable disable

//using System;
//using System.ClientModel.Primitives;
//using System.Collections.Generic;
//using System.Text.Json;
//using Azure.Core;
//using Azure.ResourceManager.Models;
//using Azure.ResourceManager.NetApp;
//using Azure.ResourceManager.NetApp.Models;

//namespace Azure.ResourceManager.NetApp
//{
//    public partial class NetAppBackupData : IUtf8JsonSerializable, IJsonModel<NetAppBackupData>
//    {
//        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<NetAppBackupData>)this).Write(writer, new ModelReaderWriterOptions("W"));

//        void IJsonModel<NetAppBackupData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
//        {
//            var format = options.Format == "W" ? ((IPersistableModel<NetAppVault>)this).GetFormatFromOptions(options) : options.Format;
//            if (format != "J")
//            {
//                throw new FormatException($"The model {nameof(NetAppVault)} does not support '{format}' format.");
//            }
//            writer.WriteStartObject();
//            if (options.Format != "W")
//            {
//                writer.WritePropertyName("id"u8);
//                writer.WriteStringValue(Id);
//            }
//            if (options.Format != "W")
//            {
//                writer.WritePropertyName("name"u8);
//                writer.WriteStringValue(Name);
//            }
//            if (options.Format != "W")
//            {
//                writer.WritePropertyName("type"u8);
//                writer.WriteStringValue(ResourceType);
//            }
//            if (options.Format != "W" && Optional.IsDefined(SystemData))
//            {
//                writer.WritePropertyName("systemData"u8);
//                JsonSerializer.Serialize(writer, SystemData);
//            }
//            writer.WritePropertyName("location"u8);
//            writer.WriteStringValue(Location);
//            writer.WritePropertyName("properties"u8);
//            writer.WriteStartObject();
//            if (options.Format != "W" && Optional.IsDefined(BackupId))
//            {
//                writer.WritePropertyName("backupId"u8);
//                writer.WriteStringValue(BackupId);
//            }
//            if (options.Format != "W" && Optional.IsDefined(CreatedOn))
//            {
//                writer.WritePropertyName("creationDate"u8);
//                writer.WriteStringValue(CreatedOn.Value, "O");
//            }
//            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
//            {
//                writer.WritePropertyName("provisioningState"u8);
//                writer.WriteStringValue(ProvisioningState);
//            }
//            if (options.Format != "W" && Optional.IsDefined(Size))
//            {
//                writer.WritePropertyName("size"u8);
//                writer.WriteNumberValue((long)Size);
//            }
//            if (Optional.IsDefined(Label))
//            {
//                writer.WritePropertyName("label"u8);
//                writer.WriteStringValue(Label);
//            }
//            if (options.Format != "W" && Optional.IsDefined(BackupType))
//            {
//                writer.WritePropertyName("backupType"u8);
//                writer.WriteStringValue(BackupType.Value.ToString());
//            }
//            if (options.Format != "W" && Optional.IsDefined(FailureReason))
//            {
//                writer.WritePropertyName("failureReason"u8);
//                writer.WriteStringValue(FailureReason);
//            }
//            if (options.Format != "W" && Optional.IsDefined(VolumeName))
//            {
//                writer.WritePropertyName("volumeName"u8);
//                writer.WriteStringValue(VolumeName);
//            }
//            if (Optional.IsDefined(UseExistingSnapshot))
//            {
//                writer.WritePropertyName("useExistingSnapshot"u8);
//                writer.WriteBooleanValue(UseExistingSnapshot.Value);
//            }
//            writer.WriteEndObject();
//            if (options.Format != "W" && _serializedAdditionalRawData != null)
//            {
//                foreach (var item in _serializedAdditionalRawData)
//                {
//                    writer.WritePropertyName(item.Key);
//#if NET6_0_OR_GREATER
//				writer.WriteRawValue(item.Value);
//#else
//                    using (JsonDocument document = JsonDocument.Parse(item.Value))
//                    {
//                        JsonSerializer.Serialize(writer, document.RootElement);
//                    }
//#endif
//                }
//            }
//            writer.WriteEndObject();
//        }

//        NetAppBackupData IJsonModel<NetAppBackupData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
//        {
//            var format = options.Format == "W" ? ((IPersistableModel<NetAppBackupData>)this).GetFormatFromOptions(options) : options.Format;
//            if (format != "J")
//            {
//                throw new FormatException($"The model {nameof(NetAppBackupData)} does not support '{format}' format.");
//            }

//            using JsonDocument document = JsonDocument.ParseValue(ref reader);
//            return DeserializeNetAppBackupData(document.RootElement, options);
//        }

//        internal static NetAppBackupData DeserializeNetAppBackupData(JsonElement element, ModelReaderWriterOptions options = null)
//        {
//            options ??= new ModelReaderWriterOptions("W");

//            if (element.ValueKind == JsonValueKind.Null)
//            {
//                return null;
//            }
//            AzureLocation location = default;
//            ResourceIdentifier id = default;
//            string name = default;
//            ResourceType type = default;
//            Azure.ResourceManager.Models.SystemData systemData = default;
//            string backupId = default;
//            DateTimeOffset creationDate = default;
//            string provisioningState = default;
//            long size = default;
//            string label = default;
//            NetAppBackupType backupType = default;
//            string failureReason = default;
//            string volumeName = default;
//            bool useExistingSnapshot = default;
//            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
//            Dictionary<string, BinaryData> additionalPropertiesDictionary = new Dictionary<string, BinaryData>();
//            foreach (var property in element.EnumerateObject())
//            {
//                if (property.NameEquals("location"u8))
//                {
//                    location = new AzureLocation(property.Value.GetString());
//                    continue;
//                }
//                if (property.NameEquals("id"u8))
//                {
//                    id = new ResourceIdentifier(property.Value.GetString());
//                    continue;
//                }
//                if (property.NameEquals("name"u8))
//                {
//                    name = property.Value.GetString();
//                    continue;
//                }
//                if (property.NameEquals("type"u8))
//                {
//                    type = new ResourceType(property.Value.GetString());
//                    continue;
//                }
//                if (property.NameEquals("systemData"u8))
//                {
//                    if (property.Value.ValueKind == JsonValueKind.Null)
//                    {
//                        continue;
//                    }
//                    systemData = JsonSerializer.Deserialize<Azure.ResourceManager.Models.SystemData>(property.Value.GetRawText());
//                    continue;
//                }
//                if (property.NameEquals("properties"u8))
//                {
//                    if (property.Value.ValueKind == JsonValueKind.Null)
//                    {
//                        continue;
//                    }
//                    foreach (var property0 in property.Value.EnumerateObject())
//                    {
//                        if (property0.NameEquals("backupId"u8))
//                        {
//                            backupId = property0.Value.GetString();
//                            continue;
//                        }
//                        if (property0.NameEquals("creationDate"u8))
//                        {
//                            if (property0.Value.ValueKind == JsonValueKind.Null)
//                            {
//                                continue;
//                            }
//                            creationDate = property0.Value.GetDateTimeOffset("O");
//                            continue;
//                        }
//                        if (property0.NameEquals("provisioningState"u8))
//                        {
//                            provisioningState = property0.Value.GetString();
//                            continue;
//                        }
//                        if (property0.NameEquals("size"u8))
//                        {
//                            if (property0.Value.ValueKind == JsonValueKind.Null)
//                            {
//                                continue;
//                            }
//                            size = property0.Value.GetInt64();
//                            continue;
//                        }
//                        if (property0.NameEquals("label"u8))
//                        {
//                            label = property0.Value.GetString();
//                            continue;
//                        }
//                        if (property0.NameEquals("backupType"u8))
//                        {
//                            if (property0.Value.ValueKind == JsonValueKind.Null)
//                            {
//                                continue;
//                            }
//                            backupType = new NetAppBackupType(property0.Value.GetString());
//                            continue;
//                        }
//                        if (property0.NameEquals("failureReason"u8))
//                        {
//                            failureReason = property0.Value.GetString();
//                            continue;
//                        }
//                        if (property0.NameEquals("volumeName"u8))
//                        {
//                            volumeName = property0.Value.GetString();
//                            continue;
//                        }
//                        if (property0.NameEquals("useExistingSnapshot"u8))
//                        {
//                            if (property0.Value.ValueKind == JsonValueKind.Null)
//                            {
//                                continue;
//                            }
//                            useExistingSnapshot = property0.Value.GetBoolean();
//                            continue;
//                        }
//                    }
//                    continue;
//                }
//                if (options.Format != "W")
//                {
//                    additionalPropertiesDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
//                }
//            }
//            serializedAdditionalRawData = additionalPropertiesDictionary;
//            return new NetAppBackupData(id, name, type, systemData, location, backupId, creationDate, provisioningState, size, label, backupType, failureReason, volumeName, useExistingSnapshot, serializedAdditionalRawData);
//        }

//        BinaryData IPersistableModel<NetAppBackupData>.Write(ModelReaderWriterOptions options)
//        {
//            var format = options.Format == "W" ? ((IPersistableModel<NetAppBackupData>)this).GetFormatFromOptions(options) : options.Format;

//            switch (format)
//            {
//                case "J":
//                    return ModelReaderWriter.Write(this, options);
//                default:
//                    throw new FormatException($"The model {nameof(NetAppBackupData)} does not support '{options.Format}' format.");
//            }
//        }

//        NetAppBackupData IPersistableModel<NetAppBackupData>.Create(BinaryData data, ModelReaderWriterOptions options)
//        {
//            var format = options.Format == "W" ? ((IPersistableModel<NetAppBackupData>)this).GetFormatFromOptions(options) : options.Format;

//            switch (format)
//            {
//                case "J":
//                    {
//                        using JsonDocument document = JsonDocument.Parse(data);
//                        return DeserializeNetAppBackupData(document.RootElement, options);
//                    }
//                default:
//                    throw new FormatException($"The model {nameof(NetAppBackupData)} does not support '{options.Format}' format.");
//            }
//        }

//        string IPersistableModel<NetAppBackupData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
//    }
//}
