// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.NetApp.Models;

namespace Azure.ResourceManager.NetApp.Samples
{
    public partial class Sample_NetAppVolumeQuotaRuleResource
    {
        // VolumeQuotaRules_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_VolumeQuotaRulesGet()
        {
            // Generated from example definition: specification/netapp/resource-manager/Microsoft.NetApp/stable/2024-07-01/examples/VolumeQuotaRules_Get.json
            // this example is just showing the usage of "VolumeQuotaRules_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this NetAppVolumeQuotaRuleResource created on azure
            // for more information of creating NetAppVolumeQuotaRuleResource, please refer to the document of NetAppVolumeQuotaRuleResource
            string subscriptionId = "5275316f-a498-48d6-b324-2cbfdc4311b9";
            string resourceGroupName = "myRG";
            string accountName = "account-9957";
            string poolName = "pool-5210";
            string volumeName = "volume-6387";
            string volumeQuotaRuleName = "rule-0004";
            ResourceIdentifier netAppVolumeQuotaRuleResourceId = NetAppVolumeQuotaRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName);
            NetAppVolumeQuotaRuleResource netAppVolumeQuotaRule = client.GetNetAppVolumeQuotaRuleResource(netAppVolumeQuotaRuleResourceId);

            // invoke the operation
            NetAppVolumeQuotaRuleResource result = await netAppVolumeQuotaRule.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            NetAppVolumeQuotaRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // VolumeQuotaRules_Update
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_VolumeQuotaRulesUpdate()
        {
            // Generated from example definition: specification/netapp/resource-manager/Microsoft.NetApp/stable/2024-07-01/examples/VolumeQuotaRules_Update.json
            // this example is just showing the usage of "VolumeQuotaRules_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this NetAppVolumeQuotaRuleResource created on azure
            // for more information of creating NetAppVolumeQuotaRuleResource, please refer to the document of NetAppVolumeQuotaRuleResource
            string subscriptionId = "5275316f-a498-48d6-b324-2cbfdc4311b9";
            string resourceGroupName = "myRG";
            string accountName = "account-9957";
            string poolName = "pool-5210";
            string volumeName = "volume-6387";
            string volumeQuotaRuleName = "rule-0004";
            ResourceIdentifier netAppVolumeQuotaRuleResourceId = NetAppVolumeQuotaRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName);
            NetAppVolumeQuotaRuleResource netAppVolumeQuotaRule = client.GetNetAppVolumeQuotaRuleResource(netAppVolumeQuotaRuleResourceId);

            // invoke the operation
            NetAppVolumeQuotaRulePatch patch = new NetAppVolumeQuotaRulePatch()
            {
                QuotaSizeInKiBs = 100009L,
            };
            ArmOperation<NetAppVolumeQuotaRuleResource> lro = await netAppVolumeQuotaRule.UpdateAsync(WaitUntil.Completed, patch);
            NetAppVolumeQuotaRuleResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            NetAppVolumeQuotaRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // VolumeQuotaRules_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_VolumeQuotaRulesDelete()
        {
            // Generated from example definition: specification/netapp/resource-manager/Microsoft.NetApp/stable/2024-07-01/examples/VolumeQuotaRules_Delete.json
            // this example is just showing the usage of "VolumeQuotaRules_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this NetAppVolumeQuotaRuleResource created on azure
            // for more information of creating NetAppVolumeQuotaRuleResource, please refer to the document of NetAppVolumeQuotaRuleResource
            string subscriptionId = "5275316f-a498-48d6-b324-2cbfdc4311b9";
            string resourceGroupName = "myRG";
            string accountName = "account-9957";
            string poolName = "pool-5210";
            string volumeName = "volume-6387";
            string volumeQuotaRuleName = "rule-0004";
            ResourceIdentifier netAppVolumeQuotaRuleResourceId = NetAppVolumeQuotaRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName);
            NetAppVolumeQuotaRuleResource netAppVolumeQuotaRule = client.GetNetAppVolumeQuotaRuleResource(netAppVolumeQuotaRuleResourceId);

            // invoke the operation
            await netAppVolumeQuotaRule.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
