// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.MySql.FlexibleServers.Models;

namespace Azure.ResourceManager.MySql.FlexibleServers
{
    /// <summary>
    /// A class representing the MySqlFlexibleServersCapability data model.
    /// Represents a location capability set.
    /// </summary>
    public partial class MySqlFlexibleServersCapabilityData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServersCapabilityData"/>. </summary>
        public MySqlFlexibleServersCapabilityData()
        {
            SupportedGeoBackupRegions = new ChangeTrackingList<string>();
            SupportedFlexibleServerEditions = new ChangeTrackingList<ServerEditionCapabilityV2>();
            SupportedServerVersions = new ChangeTrackingList<ServerVersionCapabilityV2>();
        }

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServersCapabilityData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="supportedGeoBackupRegions"> supported geo backup regions. </param>
        /// <param name="supportedFlexibleServerEditions"> A list of supported flexible server editions. </param>
        /// <param name="supportedServerVersions"> A list of supported server versions. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MySqlFlexibleServersCapabilityData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IReadOnlyList<string> supportedGeoBackupRegions, IReadOnlyList<ServerEditionCapabilityV2> supportedFlexibleServerEditions, IReadOnlyList<ServerVersionCapabilityV2> supportedServerVersions, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            SupportedGeoBackupRegions = supportedGeoBackupRegions;
            SupportedFlexibleServerEditions = supportedFlexibleServerEditions;
            SupportedServerVersions = supportedServerVersions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> supported geo backup regions. </summary>
        public IReadOnlyList<string> SupportedGeoBackupRegions { get; }
        /// <summary> A list of supported flexible server editions. </summary>
        public IReadOnlyList<ServerEditionCapabilityV2> SupportedFlexibleServerEditions { get; }
        /// <summary> A list of supported server versions. </summary>
        public IReadOnlyList<ServerVersionCapabilityV2> SupportedServerVersions { get; }
    }
}
