// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.MySql.FlexibleServers.Models;

namespace Azure.ResourceManager.MySql.FlexibleServers
{
    /// <summary>
    /// A class representing the MySqlFlexibleServerMaintenance data model.
    /// Represents a maintenance.
    /// </summary>
    public partial class MySqlFlexibleServerMaintenanceData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerMaintenanceData"/>. </summary>
        public MySqlFlexibleServerMaintenanceData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerMaintenanceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="maintenanceType"> A string defines maintenance type. </param>
        /// <param name="maintenanceState"> A string describes the maintenance status. </param>
        /// <param name="maintenanceStartOn"> The start time for a maintenance. </param>
        /// <param name="maintenanceEndOn"> The end time for a maintenance. </param>
        /// <param name="maintenanceExecutionStartOn"> The start time for a maintenance execution. </param>
        /// <param name="maintenanceExecutionEndOn"> The end time for a maintenance execution. </param>
        /// <param name="maintenanceAvailableScheduleMinOn"> The min time the maintenance can be rescheduled. </param>
        /// <param name="maintenanceAvailableScheduleMaxOn"> The max time the maintenance can be rescheduled. </param>
        /// <param name="maintenanceTitle"> The maintenance title. </param>
        /// <param name="maintenanceDescription"> The maintenance description. </param>
        /// <param name="provisioningState"> Provisioning state of the Maintenance. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MySqlFlexibleServerMaintenanceData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, MySqlFlexibleServerMaintenanceType? maintenanceType, MySqlFlexibleServerMaintenanceState? maintenanceState, DateTimeOffset? maintenanceStartOn, DateTimeOffset? maintenanceEndOn, DateTimeOffset? maintenanceExecutionStartOn, DateTimeOffset? maintenanceExecutionEndOn, DateTimeOffset? maintenanceAvailableScheduleMinOn, DateTimeOffset? maintenanceAvailableScheduleMaxOn, string maintenanceTitle, string maintenanceDescription, MySqlFlexibleServerMaintenanceProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            MaintenanceType = maintenanceType;
            MaintenanceState = maintenanceState;
            MaintenanceStartOn = maintenanceStartOn;
            MaintenanceEndOn = maintenanceEndOn;
            MaintenanceExecutionStartOn = maintenanceExecutionStartOn;
            MaintenanceExecutionEndOn = maintenanceExecutionEndOn;
            MaintenanceAvailableScheduleMinOn = maintenanceAvailableScheduleMinOn;
            MaintenanceAvailableScheduleMaxOn = maintenanceAvailableScheduleMaxOn;
            MaintenanceTitle = maintenanceTitle;
            MaintenanceDescription = maintenanceDescription;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> A string defines maintenance type. </summary>
        public MySqlFlexibleServerMaintenanceType? MaintenanceType { get; }
        /// <summary> A string describes the maintenance status. </summary>
        public MySqlFlexibleServerMaintenanceState? MaintenanceState { get; }
        /// <summary> The start time for a maintenance. </summary>
        public DateTimeOffset? MaintenanceStartOn { get; set; }
        /// <summary> The end time for a maintenance. </summary>
        public DateTimeOffset? MaintenanceEndOn { get; }
        /// <summary> The start time for a maintenance execution. </summary>
        public DateTimeOffset? MaintenanceExecutionStartOn { get; }
        /// <summary> The end time for a maintenance execution. </summary>
        public DateTimeOffset? MaintenanceExecutionEndOn { get; }
        /// <summary> The min time the maintenance can be rescheduled. </summary>
        public DateTimeOffset? MaintenanceAvailableScheduleMinOn { get; }
        /// <summary> The max time the maintenance can be rescheduled. </summary>
        public DateTimeOffset? MaintenanceAvailableScheduleMaxOn { get; }
        /// <summary> The maintenance title. </summary>
        public string MaintenanceTitle { get; }
        /// <summary> The maintenance description. </summary>
        public string MaintenanceDescription { get; }
        /// <summary> Provisioning state of the Maintenance. </summary>
        public MySqlFlexibleServerMaintenanceProvisioningState? ProvisioningState { get; }
    }
}
