// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.MySql.FlexibleServers.Models;

namespace Azure.ResourceManager.MySql.FlexibleServers
{
    public partial class MySqlFlexibleServerMaintenanceData : IUtf8JsonSerializable, IJsonModel<MySqlFlexibleServerMaintenanceData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MySqlFlexibleServerMaintenanceData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MySqlFlexibleServerMaintenanceData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MySqlFlexibleServerMaintenanceData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MySqlFlexibleServerMaintenanceData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(MaintenanceType))
            {
                writer.WritePropertyName("maintenanceType"u8);
                writer.WriteStringValue(MaintenanceType.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(MaintenanceState))
            {
                writer.WritePropertyName("maintenanceState"u8);
                writer.WriteStringValue(MaintenanceState.Value.ToString());
            }
            if (Optional.IsDefined(MaintenanceStartOn))
            {
                writer.WritePropertyName("maintenanceStartTime"u8);
                writer.WriteStringValue(MaintenanceStartOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(MaintenanceEndOn))
            {
                writer.WritePropertyName("maintenanceEndTime"u8);
                writer.WriteStringValue(MaintenanceEndOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(MaintenanceExecutionStartOn))
            {
                writer.WritePropertyName("maintenanceExecutionStartTime"u8);
                writer.WriteStringValue(MaintenanceExecutionStartOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(MaintenanceExecutionEndOn))
            {
                writer.WritePropertyName("maintenanceExecutionEndTime"u8);
                writer.WriteStringValue(MaintenanceExecutionEndOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(MaintenanceAvailableScheduleMinOn))
            {
                writer.WritePropertyName("maintenanceAvailableScheduleMinTime"u8);
                writer.WriteStringValue(MaintenanceAvailableScheduleMinOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(MaintenanceAvailableScheduleMaxOn))
            {
                writer.WritePropertyName("maintenanceAvailableScheduleMaxTime"u8);
                writer.WriteStringValue(MaintenanceAvailableScheduleMaxOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(MaintenanceTitle))
            {
                writer.WritePropertyName("maintenanceTitle"u8);
                writer.WriteStringValue(MaintenanceTitle);
            }
            if (options.Format != "W" && Optional.IsDefined(MaintenanceDescription))
            {
                writer.WritePropertyName("maintenanceDescription"u8);
                writer.WriteStringValue(MaintenanceDescription);
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            writer.WriteEndObject();
        }

        MySqlFlexibleServerMaintenanceData IJsonModel<MySqlFlexibleServerMaintenanceData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MySqlFlexibleServerMaintenanceData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MySqlFlexibleServerMaintenanceData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMySqlFlexibleServerMaintenanceData(document.RootElement, options);
        }

        internal static MySqlFlexibleServerMaintenanceData DeserializeMySqlFlexibleServerMaintenanceData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            MySqlFlexibleServerMaintenanceType? maintenanceType = default;
            MySqlFlexibleServerMaintenanceState? maintenanceState = default;
            DateTimeOffset? maintenanceStartTime = default;
            DateTimeOffset? maintenanceEndTime = default;
            DateTimeOffset? maintenanceExecutionStartTime = default;
            DateTimeOffset? maintenanceExecutionEndTime = default;
            DateTimeOffset? maintenanceAvailableScheduleMinTime = default;
            DateTimeOffset? maintenanceAvailableScheduleMaxTime = default;
            string maintenanceTitle = default;
            string maintenanceDescription = default;
            MySqlFlexibleServerMaintenanceProvisioningState? provisioningState = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("maintenanceType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            maintenanceType = new MySqlFlexibleServerMaintenanceType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("maintenanceState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            maintenanceState = new MySqlFlexibleServerMaintenanceState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("maintenanceStartTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            maintenanceStartTime = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("maintenanceEndTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            maintenanceEndTime = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("maintenanceExecutionStartTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            maintenanceExecutionStartTime = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("maintenanceExecutionEndTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            maintenanceExecutionEndTime = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("maintenanceAvailableScheduleMinTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            maintenanceAvailableScheduleMinTime = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("maintenanceAvailableScheduleMaxTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            maintenanceAvailableScheduleMaxTime = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("maintenanceTitle"u8))
                        {
                            maintenanceTitle = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("maintenanceDescription"u8))
                        {
                            maintenanceDescription = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new MySqlFlexibleServerMaintenanceProvisioningState(property0.Value.GetString());
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new MySqlFlexibleServerMaintenanceData(
                id,
                name,
                type,
                systemData,
                maintenanceType,
                maintenanceState,
                maintenanceStartTime,
                maintenanceEndTime,
                maintenanceExecutionStartTime,
                maintenanceExecutionEndTime,
                maintenanceAvailableScheduleMinTime,
                maintenanceAvailableScheduleMaxTime,
                maintenanceTitle,
                maintenanceDescription,
                provisioningState,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<MySqlFlexibleServerMaintenanceData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MySqlFlexibleServerMaintenanceData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(MySqlFlexibleServerMaintenanceData)} does not support writing '{options.Format}' format.");
            }
        }

        MySqlFlexibleServerMaintenanceData IPersistableModel<MySqlFlexibleServerMaintenanceData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MySqlFlexibleServerMaintenanceData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMySqlFlexibleServerMaintenanceData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MySqlFlexibleServerMaintenanceData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MySqlFlexibleServerMaintenanceData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
