// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.MySql.FlexibleServers.Models;

namespace Azure.ResourceManager.MySql.FlexibleServers
{
    /// <summary>
    /// A class representing the MySqlFlexibleServerConfiguration data model.
    /// Represents a Configuration.
    /// </summary>
    public partial class MySqlFlexibleServerConfigurationData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerConfigurationData"/>. </summary>
        public MySqlFlexibleServerConfigurationData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerConfigurationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="value"> Value of the configuration. </param>
        /// <param name="currentValue"> Current value of the configuration. </param>
        /// <param name="description"> Description of the configuration. </param>
        /// <param name="documentationLink"> The link used to get the document from community or Azure site. </param>
        /// <param name="defaultValue"> Default value of the configuration. </param>
        /// <param name="dataType"> Data type of the configuration. </param>
        /// <param name="allowedValues"> Allowed values of the configuration. </param>
        /// <param name="source"> Source of the configuration. </param>
        /// <param name="isReadOnly"> If is the configuration read only. </param>
        /// <param name="isConfigPendingRestart"> If is the configuration pending restart or not. </param>
        /// <param name="isDynamicConfig"> If is the configuration dynamic. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MySqlFlexibleServerConfigurationData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string value, string currentValue, string description, string documentationLink, string defaultValue, string dataType, string allowedValues, MySqlFlexibleServerConfigurationSource? source, MySqlFlexibleServerConfigReadOnlyState? isReadOnly, MySqlFlexibleServerConfigPendingRestartState? isConfigPendingRestart, MySqlFlexibleServerConfigDynamicState? isDynamicConfig, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Value = value;
            CurrentValue = currentValue;
            Description = description;
            DocumentationLink = documentationLink;
            DefaultValue = defaultValue;
            DataType = dataType;
            AllowedValues = allowedValues;
            Source = source;
            IsReadOnly = isReadOnly;
            IsConfigPendingRestart = isConfigPendingRestart;
            IsDynamicConfig = isDynamicConfig;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Value of the configuration. </summary>
        public string Value { get; set; }
        /// <summary> Current value of the configuration. </summary>
        public string CurrentValue { get; set; }
        /// <summary> Description of the configuration. </summary>
        public string Description { get; }
        /// <summary> The link used to get the document from community or Azure site. </summary>
        public string DocumentationLink { get; }
        /// <summary> Default value of the configuration. </summary>
        public string DefaultValue { get; }
        /// <summary> Data type of the configuration. </summary>
        public string DataType { get; }
        /// <summary> Allowed values of the configuration. </summary>
        public string AllowedValues { get; }
        /// <summary> Source of the configuration. </summary>
        public MySqlFlexibleServerConfigurationSource? Source { get; set; }
        /// <summary> If is the configuration read only. </summary>
        public MySqlFlexibleServerConfigReadOnlyState? IsReadOnly { get; }
        /// <summary> If is the configuration pending restart or not. </summary>
        public MySqlFlexibleServerConfigPendingRestartState? IsConfigPendingRestart { get; }
        /// <summary> If is the configuration dynamic. </summary>
        public MySqlFlexibleServerConfigDynamicState? IsDynamicConfig { get; }
    }
}
