// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.MySql.FlexibleServers.Models;

namespace Azure.ResourceManager.MySql.FlexibleServers
{
    /// <summary>
    /// A class representing the MySqlFlexibleServerBackupV2 data model.
    /// Server backup properties
    /// </summary>
    public partial class MySqlFlexibleServerBackupV2Data : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerBackupV2Data"/>. </summary>
        public MySqlFlexibleServerBackupV2Data()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerBackupV2Data"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="backupNameV2"> Backup name. </param>
        /// <param name="backupType"></param>
        /// <param name="completedOn"> Backup completed time (ISO8601 format). </param>
        /// <param name="source"> Backup source. </param>
        /// <param name="provisioningState"> The provisioning state of backup resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MySqlFlexibleServerBackupV2Data(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string backupNameV2, MySqlFlexibleServerBackupType? backupType, DateTimeOffset? completedOn, string source, MySqlFlexibleServerBackupProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            BackupNameV2 = backupNameV2;
            BackupType = backupType;
            CompletedOn = completedOn;
            Source = source;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Backup name. </summary>
        public string BackupNameV2 { get; set; }
        /// <summary> Gets or sets the backup type. </summary>
        public MySqlFlexibleServerBackupType? BackupType { get; set; }
        /// <summary> Backup completed time (ISO8601 format). </summary>
        public DateTimeOffset? CompletedOn { get; set; }
        /// <summary> Backup source. </summary>
        public string Source { get; set; }
        /// <summary> The provisioning state of backup resource. </summary>
        public MySqlFlexibleServerBackupProvisioningState? ProvisioningState { get; }
    }
}
