// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.MySql.FlexibleServers.Models;

namespace Azure.ResourceManager.MySql.FlexibleServers
{
    /// <summary>
    /// A class representing the MySqlFlexibleServerAadAdministrator data model.
    /// Represents a Administrator.
    /// </summary>
    public partial class MySqlFlexibleServerAadAdministratorData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerAadAdministratorData"/>. </summary>
        public MySqlFlexibleServerAadAdministratorData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerAadAdministratorData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="administratorType"> Type of the sever administrator. </param>
        /// <param name="login"> Login name of the server administrator. </param>
        /// <param name="sid"> SID (object ID) of the server administrator. </param>
        /// <param name="tenantId"> Tenant ID of the administrator. </param>
        /// <param name="identityResourceId"> The resource id of the identity used for AAD Authentication. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MySqlFlexibleServerAadAdministratorData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, MySqlFlexibleServerAdministratorType? administratorType, string login, string sid, Guid? tenantId, ResourceIdentifier identityResourceId, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            AdministratorType = administratorType;
            Login = login;
            Sid = sid;
            TenantId = tenantId;
            IdentityResourceId = identityResourceId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Type of the sever administrator. </summary>
        public MySqlFlexibleServerAdministratorType? AdministratorType { get; set; }
        /// <summary> Login name of the server administrator. </summary>
        public string Login { get; set; }
        /// <summary> SID (object ID) of the server administrator. </summary>
        public string Sid { get; set; }
        /// <summary> Tenant ID of the administrator. </summary>
        public Guid? TenantId { get; set; }
        /// <summary> The resource id of the identity used for AAD Authentication. </summary>
        public ResourceIdentifier IdentityResourceId { get; set; }
    }
}
