// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MySql.FlexibleServers.Models
{
    /// <summary> Sku capability. </summary>
    public partial class SkuCapabilityV2
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SkuCapabilityV2"/>. </summary>
        internal SkuCapabilityV2()
        {
            SupportedZones = new ChangeTrackingList<string>();
            SupportedHAMode = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="SkuCapabilityV2"/>. </summary>
        /// <param name="name"> vCore name. </param>
        /// <param name="vCores"> supported vCores. </param>
        /// <param name="supportedIops"> supported IOPS. </param>
        /// <param name="supportedMemoryPerVCoreMB"> supported memory per vCore in MB. </param>
        /// <param name="supportedZones"> Supported zones. </param>
        /// <param name="supportedHAMode"> Supported high availability mode. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SkuCapabilityV2(string name, long? vCores, long? supportedIops, long? supportedMemoryPerVCoreMB, IReadOnlyList<string> supportedZones, IReadOnlyList<string> supportedHAMode, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            VCores = vCores;
            SupportedIops = supportedIops;
            SupportedMemoryPerVCoreMB = supportedMemoryPerVCoreMB;
            SupportedZones = supportedZones;
            SupportedHAMode = supportedHAMode;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> vCore name. </summary>
        public string Name { get; }
        /// <summary> supported vCores. </summary>
        public long? VCores { get; }
        /// <summary> supported IOPS. </summary>
        public long? SupportedIops { get; }
        /// <summary> supported memory per vCore in MB. </summary>
        public long? SupportedMemoryPerVCoreMB { get; }
        /// <summary> Supported zones. </summary>
        public IReadOnlyList<string> SupportedZones { get; }
        /// <summary> Supported high availability mode. </summary>
        public IReadOnlyList<string> SupportedHAMode { get; }
    }
}
