// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MySql.FlexibleServers.Models
{
    public partial class SkuCapabilityV2 : IUtf8JsonSerializable, IJsonModel<SkuCapabilityV2>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SkuCapabilityV2>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SkuCapabilityV2>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SkuCapabilityV2>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SkuCapabilityV2)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(Name))
            {
                writer.WritePropertyName("name"u8);
                writer.WriteStringValue(Name);
            }
            if (options.Format != "W" && Optional.IsDefined(VCores))
            {
                writer.WritePropertyName("vCores"u8);
                writer.WriteNumberValue(VCores.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(SupportedIops))
            {
                writer.WritePropertyName("supportedIops"u8);
                writer.WriteNumberValue(SupportedIops.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(SupportedMemoryPerVCoreMB))
            {
                writer.WritePropertyName("supportedMemoryPerVCoreMB"u8);
                writer.WriteNumberValue(SupportedMemoryPerVCoreMB.Value);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(SupportedZones))
            {
                writer.WritePropertyName("supportedZones"u8);
                writer.WriteStartArray();
                foreach (var item in SupportedZones)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(SupportedHAMode))
            {
                writer.WritePropertyName("supportedHAMode"u8);
                writer.WriteStartArray();
                foreach (var item in SupportedHAMode)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SkuCapabilityV2 IJsonModel<SkuCapabilityV2>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SkuCapabilityV2>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SkuCapabilityV2)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSkuCapabilityV2(document.RootElement, options);
        }

        internal static SkuCapabilityV2 DeserializeSkuCapabilityV2(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string name = default;
            long? vCores = default;
            long? supportedIops = default;
            long? supportedMemoryPerVCoreMB = default;
            IReadOnlyList<string> supportedZones = default;
            IReadOnlyList<string> supportedHAMode = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("vCores"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    vCores = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("supportedIops"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    supportedIops = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("supportedMemoryPerVCoreMB"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    supportedMemoryPerVCoreMB = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("supportedZones"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    supportedZones = array;
                    continue;
                }
                if (property.NameEquals("supportedHAMode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    supportedHAMode = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SkuCapabilityV2(
                name,
                vCores,
                supportedIops,
                supportedMemoryPerVCoreMB,
                supportedZones ?? new ChangeTrackingList<string>(),
                supportedHAMode ?? new ChangeTrackingList<string>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SkuCapabilityV2>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SkuCapabilityV2>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SkuCapabilityV2)} does not support writing '{options.Format}' format.");
            }
        }

        SkuCapabilityV2 IPersistableModel<SkuCapabilityV2>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SkuCapabilityV2>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSkuCapabilityV2(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SkuCapabilityV2)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SkuCapabilityV2>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
