// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MySql.FlexibleServers.Models
{
    /// <summary> Server edition capabilities. </summary>
    public partial class ServerEditionCapabilityV2
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ServerEditionCapabilityV2"/>. </summary>
        internal ServerEditionCapabilityV2()
        {
            SupportedStorageEditions = new ChangeTrackingList<MySqlFlexibleServerStorageEditionCapability>();
            SupportedSkus = new ChangeTrackingList<SkuCapabilityV2>();
        }

        /// <summary> Initializes a new instance of <see cref="ServerEditionCapabilityV2"/>. </summary>
        /// <param name="name"> Server edition name. </param>
        /// <param name="defaultSku"> Default Sku name. </param>
        /// <param name="defaultStorageSize"> Default storage size. </param>
        /// <param name="supportedStorageEditions"> A list of supported storage editions. </param>
        /// <param name="supportedSkus"> A list of supported Skus. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ServerEditionCapabilityV2(string name, string defaultSku, int? defaultStorageSize, IReadOnlyList<MySqlFlexibleServerStorageEditionCapability> supportedStorageEditions, IReadOnlyList<SkuCapabilityV2> supportedSkus, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            DefaultSku = defaultSku;
            DefaultStorageSize = defaultStorageSize;
            SupportedStorageEditions = supportedStorageEditions;
            SupportedSkus = supportedSkus;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Server edition name. </summary>
        public string Name { get; }
        /// <summary> Default Sku name. </summary>
        public string DefaultSku { get; }
        /// <summary> Default storage size. </summary>
        public int? DefaultStorageSize { get; }
        /// <summary> A list of supported storage editions. </summary>
        public IReadOnlyList<MySqlFlexibleServerStorageEditionCapability> SupportedStorageEditions { get; }
        /// <summary> A list of supported Skus. </summary>
        public IReadOnlyList<SkuCapabilityV2> SupportedSkus { get; }
    }
}
