// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MySql.FlexibleServers.Models
{
    /// <summary> The current provisioning state. </summary>
    public readonly partial struct MySqlFlexibleServersPrivateEndpointConnectionProvisioningState : IEquatable<MySqlFlexibleServersPrivateEndpointConnectionProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServersPrivateEndpointConnectionProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MySqlFlexibleServersPrivateEndpointConnectionProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string CreatingValue = "Creating";
        private const string DeletingValue = "Deleting";
        private const string FailedValue = "Failed";

        /// <summary> Succeeded. </summary>
        public static MySqlFlexibleServersPrivateEndpointConnectionProvisioningState Succeeded { get; } = new MySqlFlexibleServersPrivateEndpointConnectionProvisioningState(SucceededValue);
        /// <summary> Creating. </summary>
        public static MySqlFlexibleServersPrivateEndpointConnectionProvisioningState Creating { get; } = new MySqlFlexibleServersPrivateEndpointConnectionProvisioningState(CreatingValue);
        /// <summary> Deleting. </summary>
        public static MySqlFlexibleServersPrivateEndpointConnectionProvisioningState Deleting { get; } = new MySqlFlexibleServersPrivateEndpointConnectionProvisioningState(DeletingValue);
        /// <summary> Failed. </summary>
        public static MySqlFlexibleServersPrivateEndpointConnectionProvisioningState Failed { get; } = new MySqlFlexibleServersPrivateEndpointConnectionProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="MySqlFlexibleServersPrivateEndpointConnectionProvisioningState"/> values are the same. </summary>
        public static bool operator ==(MySqlFlexibleServersPrivateEndpointConnectionProvisioningState left, MySqlFlexibleServersPrivateEndpointConnectionProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MySqlFlexibleServersPrivateEndpointConnectionProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(MySqlFlexibleServersPrivateEndpointConnectionProvisioningState left, MySqlFlexibleServersPrivateEndpointConnectionProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MySqlFlexibleServersPrivateEndpointConnectionProvisioningState"/>. </summary>
        public static implicit operator MySqlFlexibleServersPrivateEndpointConnectionProvisioningState(string value) => new MySqlFlexibleServersPrivateEndpointConnectionProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MySqlFlexibleServersPrivateEndpointConnectionProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MySqlFlexibleServersPrivateEndpointConnectionProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
