// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MySql.FlexibleServers.Models
{
    /// <summary> The version of a server. </summary>
    public readonly partial struct MySqlFlexibleServerVersion : IEquatable<MySqlFlexibleServerVersion>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerVersion"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MySqlFlexibleServerVersion(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string Ver5_7Value = "5.7";
        private const string Ver8_0_21Value = "8.0.21";
        /// <summary> Determines if two <see cref="MySqlFlexibleServerVersion"/> values are the same. </summary>
        public static bool operator ==(MySqlFlexibleServerVersion left, MySqlFlexibleServerVersion right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MySqlFlexibleServerVersion"/> values are not the same. </summary>
        public static bool operator !=(MySqlFlexibleServerVersion left, MySqlFlexibleServerVersion right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MySqlFlexibleServerVersion"/>. </summary>
        public static implicit operator MySqlFlexibleServerVersion(string value) => new MySqlFlexibleServerVersion(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MySqlFlexibleServerVersion other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MySqlFlexibleServerVersion other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
