// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MySql.FlexibleServers.Models
{
    /// <summary> The state of a server. </summary>
    public readonly partial struct MySqlFlexibleServerState : IEquatable<MySqlFlexibleServerState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MySqlFlexibleServerState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ReadyValue = "Ready";
        private const string DroppingValue = "Dropping";
        private const string DisabledValue = "Disabled";
        private const string StartingValue = "Starting";
        private const string StoppingValue = "Stopping";
        private const string StoppedValue = "Stopped";
        private const string UpdatingValue = "Updating";

        /// <summary> Ready. </summary>
        public static MySqlFlexibleServerState Ready { get; } = new MySqlFlexibleServerState(ReadyValue);
        /// <summary> Dropping. </summary>
        public static MySqlFlexibleServerState Dropping { get; } = new MySqlFlexibleServerState(DroppingValue);
        /// <summary> Disabled. </summary>
        public static MySqlFlexibleServerState Disabled { get; } = new MySqlFlexibleServerState(DisabledValue);
        /// <summary> Starting. </summary>
        public static MySqlFlexibleServerState Starting { get; } = new MySqlFlexibleServerState(StartingValue);
        /// <summary> Stopping. </summary>
        public static MySqlFlexibleServerState Stopping { get; } = new MySqlFlexibleServerState(StoppingValue);
        /// <summary> Stopped. </summary>
        public static MySqlFlexibleServerState Stopped { get; } = new MySqlFlexibleServerState(StoppedValue);
        /// <summary> Updating. </summary>
        public static MySqlFlexibleServerState Updating { get; } = new MySqlFlexibleServerState(UpdatingValue);
        /// <summary> Determines if two <see cref="MySqlFlexibleServerState"/> values are the same. </summary>
        public static bool operator ==(MySqlFlexibleServerState left, MySqlFlexibleServerState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MySqlFlexibleServerState"/> values are not the same. </summary>
        public static bool operator !=(MySqlFlexibleServerState left, MySqlFlexibleServerState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MySqlFlexibleServerState"/>. </summary>
        public static implicit operator MySqlFlexibleServerState(string value) => new MySqlFlexibleServerState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MySqlFlexibleServerState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MySqlFlexibleServerState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
