// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MySql.FlexibleServers.Models
{
    /// <summary> The tier of the particular SKU, e.g. GeneralPurpose. </summary>
    public readonly partial struct MySqlFlexibleServerSkuTier : IEquatable<MySqlFlexibleServerSkuTier>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerSkuTier"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MySqlFlexibleServerSkuTier(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BurstableValue = "Burstable";
        private const string GeneralPurposeValue = "GeneralPurpose";
        private const string MemoryOptimizedValue = "MemoryOptimized";

        /// <summary> Burstable. </summary>
        public static MySqlFlexibleServerSkuTier Burstable { get; } = new MySqlFlexibleServerSkuTier(BurstableValue);
        /// <summary> GeneralPurpose. </summary>
        public static MySqlFlexibleServerSkuTier GeneralPurpose { get; } = new MySqlFlexibleServerSkuTier(GeneralPurposeValue);
        /// <summary> MemoryOptimized. </summary>
        public static MySqlFlexibleServerSkuTier MemoryOptimized { get; } = new MySqlFlexibleServerSkuTier(MemoryOptimizedValue);
        /// <summary> Determines if two <see cref="MySqlFlexibleServerSkuTier"/> values are the same. </summary>
        public static bool operator ==(MySqlFlexibleServerSkuTier left, MySqlFlexibleServerSkuTier right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MySqlFlexibleServerSkuTier"/> values are not the same. </summary>
        public static bool operator !=(MySqlFlexibleServerSkuTier left, MySqlFlexibleServerSkuTier right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MySqlFlexibleServerSkuTier"/>. </summary>
        public static implicit operator MySqlFlexibleServerSkuTier(string value) => new MySqlFlexibleServerSkuTier(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MySqlFlexibleServerSkuTier other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MySqlFlexibleServerSkuTier other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
