// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MySql.FlexibleServers.Models
{
    /// <summary> Billing information related properties of a server. </summary>
    public partial class MySqlFlexibleServerSku
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerSku"/>. </summary>
        /// <param name="name"> The name of the sku, e.g. Standard_D32s_v3. </param>
        /// <param name="tier"> The tier of the particular SKU, e.g. GeneralPurpose. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        public MySqlFlexibleServerSku(string name, MySqlFlexibleServerSkuTier tier)
        {
            Argument.AssertNotNull(name, nameof(name));

            Name = name;
            Tier = tier;
        }

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerSku"/>. </summary>
        /// <param name="name"> The name of the sku, e.g. Standard_D32s_v3. </param>
        /// <param name="tier"> The tier of the particular SKU, e.g. GeneralPurpose. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MySqlFlexibleServerSku(string name, MySqlFlexibleServerSkuTier tier, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Tier = tier;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerSku"/> for deserialization. </summary>
        internal MySqlFlexibleServerSku()
        {
        }

        /// <summary> The name of the sku, e.g. Standard_D32s_v3. </summary>
        public string Name { get; set; }
        /// <summary> The tier of the particular SKU, e.g. GeneralPurpose. </summary>
        public MySqlFlexibleServerSkuTier Tier { get; set; }
    }
}
