// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MySql.FlexibleServers.Models
{
    /// <summary> Server version capabilities. </summary>
    public partial class MySqlFlexibleServerServerVersionCapability
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerServerVersionCapability"/>. </summary>
        internal MySqlFlexibleServerServerVersionCapability()
        {
            SupportedSkus = new ChangeTrackingList<MySqlFlexibleServerSkuCapability>();
        }

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerServerVersionCapability"/>. </summary>
        /// <param name="name"> server version. </param>
        /// <param name="supportedSkus"> A list of supported Skus. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MySqlFlexibleServerServerVersionCapability(string name, IReadOnlyList<MySqlFlexibleServerSkuCapability> supportedSkus, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            SupportedSkus = supportedSkus;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> server version. </summary>
        public string Name { get; }
        /// <summary> A list of supported Skus. </summary>
        public IReadOnlyList<MySqlFlexibleServerSkuCapability> SupportedSkus { get; }
    }
}
