// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MySql.FlexibleServers.Models
{
    /// <summary> The replication role. </summary>
    public readonly partial struct MySqlFlexibleServerReplicationRole : IEquatable<MySqlFlexibleServerReplicationRole>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerReplicationRole"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MySqlFlexibleServerReplicationRole(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string SourceValue = "Source";
        private const string ReplicaValue = "Replica";

        /// <summary> None. </summary>
        public static MySqlFlexibleServerReplicationRole None { get; } = new MySqlFlexibleServerReplicationRole(NoneValue);
        /// <summary> Source. </summary>
        public static MySqlFlexibleServerReplicationRole Source { get; } = new MySqlFlexibleServerReplicationRole(SourceValue);
        /// <summary> Replica. </summary>
        public static MySqlFlexibleServerReplicationRole Replica { get; } = new MySqlFlexibleServerReplicationRole(ReplicaValue);
        /// <summary> Determines if two <see cref="MySqlFlexibleServerReplicationRole"/> values are the same. </summary>
        public static bool operator ==(MySqlFlexibleServerReplicationRole left, MySqlFlexibleServerReplicationRole right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MySqlFlexibleServerReplicationRole"/> values are not the same. </summary>
        public static bool operator !=(MySqlFlexibleServerReplicationRole left, MySqlFlexibleServerReplicationRole right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MySqlFlexibleServerReplicationRole"/>. </summary>
        public static implicit operator MySqlFlexibleServerReplicationRole(string value) => new MySqlFlexibleServerReplicationRole(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MySqlFlexibleServerReplicationRole other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MySqlFlexibleServerReplicationRole other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
