// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.MySql.FlexibleServers.Models
{
    /// <summary> Network related properties of a server. </summary>
    public partial class MySqlFlexibleServerNetwork
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerNetwork"/>. </summary>
        public MySqlFlexibleServerNetwork()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerNetwork"/>. </summary>
        /// <param name="publicNetworkAccess"> Whether or not public network access is allowed for this server. Value is 'Disabled' when server has VNet integration. </param>
        /// <param name="delegatedSubnetResourceId"> Delegated subnet resource id used to setup vnet for a server. </param>
        /// <param name="privateDnsZoneResourceId"> Private DNS zone resource id. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MySqlFlexibleServerNetwork(MySqlFlexibleServerEnableStatusEnum? publicNetworkAccess, ResourceIdentifier delegatedSubnetResourceId, ResourceIdentifier privateDnsZoneResourceId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PublicNetworkAccess = publicNetworkAccess;
            DelegatedSubnetResourceId = delegatedSubnetResourceId;
            PrivateDnsZoneResourceId = privateDnsZoneResourceId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Whether or not public network access is allowed for this server. Value is 'Disabled' when server has VNet integration. </summary>
        public MySqlFlexibleServerEnableStatusEnum? PublicNetworkAccess { get; set; }
        /// <summary> Delegated subnet resource id used to setup vnet for a server. </summary>
        public ResourceIdentifier DelegatedSubnetResourceId { get; set; }
        /// <summary> Private DNS zone resource id. </summary>
        public ResourceIdentifier PrivateDnsZoneResourceId { get; set; }
    }
}
