// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MySql.FlexibleServers.Models
{
    /// <summary> The current status of this maintenance. </summary>
    public readonly partial struct MySqlFlexibleServerMaintenanceState : IEquatable<MySqlFlexibleServerMaintenanceState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerMaintenanceState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MySqlFlexibleServerMaintenanceState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ScheduledValue = "Scheduled";
        private const string ReScheduledValue = "ReScheduled";
        private const string InPreparationValue = "InPreparation";
        private const string ProcessingValue = "Processing";
        private const string CompletedValue = "Completed";
        private const string CanceledValue = "Canceled";

        /// <summary> Scheduled. </summary>
        public static MySqlFlexibleServerMaintenanceState Scheduled { get; } = new MySqlFlexibleServerMaintenanceState(ScheduledValue);
        /// <summary> ReScheduled. </summary>
        public static MySqlFlexibleServerMaintenanceState ReScheduled { get; } = new MySqlFlexibleServerMaintenanceState(ReScheduledValue);
        /// <summary> InPreparation. </summary>
        public static MySqlFlexibleServerMaintenanceState InPreparation { get; } = new MySqlFlexibleServerMaintenanceState(InPreparationValue);
        /// <summary> Processing. </summary>
        public static MySqlFlexibleServerMaintenanceState Processing { get; } = new MySqlFlexibleServerMaintenanceState(ProcessingValue);
        /// <summary> Completed. </summary>
        public static MySqlFlexibleServerMaintenanceState Completed { get; } = new MySqlFlexibleServerMaintenanceState(CompletedValue);
        /// <summary> Canceled. </summary>
        public static MySqlFlexibleServerMaintenanceState Canceled { get; } = new MySqlFlexibleServerMaintenanceState(CanceledValue);
        /// <summary> Determines if two <see cref="MySqlFlexibleServerMaintenanceState"/> values are the same. </summary>
        public static bool operator ==(MySqlFlexibleServerMaintenanceState left, MySqlFlexibleServerMaintenanceState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MySqlFlexibleServerMaintenanceState"/> values are not the same. </summary>
        public static bool operator !=(MySqlFlexibleServerMaintenanceState left, MySqlFlexibleServerMaintenanceState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MySqlFlexibleServerMaintenanceState"/>. </summary>
        public static implicit operator MySqlFlexibleServerMaintenanceState(string value) => new MySqlFlexibleServerMaintenanceState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MySqlFlexibleServerMaintenanceState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MySqlFlexibleServerMaintenanceState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
