// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MySql.FlexibleServers.Models
{
    /// <summary> The current provisioning state. </summary>
    public readonly partial struct MySqlFlexibleServerMaintenanceProvisioningState : IEquatable<MySqlFlexibleServerMaintenanceProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerMaintenanceProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MySqlFlexibleServerMaintenanceProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string CreatingValue = "Creating";
        private const string DeletingValue = "Deleting";
        private const string FailedValue = "Failed";

        /// <summary> Succeeded. </summary>
        public static MySqlFlexibleServerMaintenanceProvisioningState Succeeded { get; } = new MySqlFlexibleServerMaintenanceProvisioningState(SucceededValue);
        /// <summary> Creating. </summary>
        public static MySqlFlexibleServerMaintenanceProvisioningState Creating { get; } = new MySqlFlexibleServerMaintenanceProvisioningState(CreatingValue);
        /// <summary> Deleting. </summary>
        public static MySqlFlexibleServerMaintenanceProvisioningState Deleting { get; } = new MySqlFlexibleServerMaintenanceProvisioningState(DeletingValue);
        /// <summary> Failed. </summary>
        public static MySqlFlexibleServerMaintenanceProvisioningState Failed { get; } = new MySqlFlexibleServerMaintenanceProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="MySqlFlexibleServerMaintenanceProvisioningState"/> values are the same. </summary>
        public static bool operator ==(MySqlFlexibleServerMaintenanceProvisioningState left, MySqlFlexibleServerMaintenanceProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MySqlFlexibleServerMaintenanceProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(MySqlFlexibleServerMaintenanceProvisioningState left, MySqlFlexibleServerMaintenanceProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MySqlFlexibleServerMaintenanceProvisioningState"/>. </summary>
        public static implicit operator MySqlFlexibleServerMaintenanceProvisioningState(string value) => new MySqlFlexibleServerMaintenanceProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MySqlFlexibleServerMaintenanceProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MySqlFlexibleServerMaintenanceProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
