// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MySql.FlexibleServers.Models
{
    /// <summary> High availability mode for a server. </summary>
    public readonly partial struct MySqlFlexibleServerHighAvailabilityMode : IEquatable<MySqlFlexibleServerHighAvailabilityMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerHighAvailabilityMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MySqlFlexibleServerHighAvailabilityMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";
        private const string ZoneRedundantValue = "ZoneRedundant";
        private const string SameZoneValue = "SameZone";

        /// <summary> Disabled. </summary>
        public static MySqlFlexibleServerHighAvailabilityMode Disabled { get; } = new MySqlFlexibleServerHighAvailabilityMode(DisabledValue);
        /// <summary> ZoneRedundant. </summary>
        public static MySqlFlexibleServerHighAvailabilityMode ZoneRedundant { get; } = new MySqlFlexibleServerHighAvailabilityMode(ZoneRedundantValue);
        /// <summary> SameZone. </summary>
        public static MySqlFlexibleServerHighAvailabilityMode SameZone { get; } = new MySqlFlexibleServerHighAvailabilityMode(SameZoneValue);
        /// <summary> Determines if two <see cref="MySqlFlexibleServerHighAvailabilityMode"/> values are the same. </summary>
        public static bool operator ==(MySqlFlexibleServerHighAvailabilityMode left, MySqlFlexibleServerHighAvailabilityMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MySqlFlexibleServerHighAvailabilityMode"/> values are not the same. </summary>
        public static bool operator !=(MySqlFlexibleServerHighAvailabilityMode left, MySqlFlexibleServerHighAvailabilityMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MySqlFlexibleServerHighAvailabilityMode"/>. </summary>
        public static implicit operator MySqlFlexibleServerHighAvailabilityMode(string value) => new MySqlFlexibleServerHighAvailabilityMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MySqlFlexibleServerHighAvailabilityMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MySqlFlexibleServerHighAvailabilityMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
