// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.MySql.FlexibleServers.Models
{
    internal static partial class MySqlFlexibleServerDataEncryptionTypeExtensions
    {
        public static string ToSerialString(this MySqlFlexibleServerDataEncryptionType value) => value switch
        {
            MySqlFlexibleServerDataEncryptionType.AzureKeyVault => "AzureKeyVault",
            MySqlFlexibleServerDataEncryptionType.SystemManaged => "SystemManaged",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown MySqlFlexibleServerDataEncryptionType value.")
        };

        public static MySqlFlexibleServerDataEncryptionType ToMySqlFlexibleServerDataEncryptionType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "AzureKeyVault")) return MySqlFlexibleServerDataEncryptionType.AzureKeyVault;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "SystemManaged")) return MySqlFlexibleServerDataEncryptionType.SystemManaged;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown MySqlFlexibleServerDataEncryptionType value.");
        }
    }
}
