// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MySql.FlexibleServers.Models
{
    /// <summary> The mode to create a new MySQL server. </summary>
    public readonly partial struct MySqlFlexibleServerCreateMode : IEquatable<MySqlFlexibleServerCreateMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerCreateMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MySqlFlexibleServerCreateMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "Default";
        private const string PointInTimeRestoreValue = "PointInTimeRestore";
        private const string ReplicaValue = "Replica";
        private const string GeoRestoreValue = "GeoRestore";

        /// <summary> Default. </summary>
        public static MySqlFlexibleServerCreateMode Default { get; } = new MySqlFlexibleServerCreateMode(DefaultValue);
        /// <summary> PointInTimeRestore. </summary>
        public static MySqlFlexibleServerCreateMode PointInTimeRestore { get; } = new MySqlFlexibleServerCreateMode(PointInTimeRestoreValue);
        /// <summary> Replica. </summary>
        public static MySqlFlexibleServerCreateMode Replica { get; } = new MySqlFlexibleServerCreateMode(ReplicaValue);
        /// <summary> GeoRestore. </summary>
        public static MySqlFlexibleServerCreateMode GeoRestore { get; } = new MySqlFlexibleServerCreateMode(GeoRestoreValue);
        /// <summary> Determines if two <see cref="MySqlFlexibleServerCreateMode"/> values are the same. </summary>
        public static bool operator ==(MySqlFlexibleServerCreateMode left, MySqlFlexibleServerCreateMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MySqlFlexibleServerCreateMode"/> values are not the same. </summary>
        public static bool operator !=(MySqlFlexibleServerCreateMode left, MySqlFlexibleServerCreateMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MySqlFlexibleServerCreateMode"/>. </summary>
        public static implicit operator MySqlFlexibleServerCreateMode(string value) => new MySqlFlexibleServerCreateMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MySqlFlexibleServerCreateMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MySqlFlexibleServerCreateMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
