// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MySql.FlexibleServers.Models
{
    /// <summary> If is the configuration pending restart or not. </summary>
    public readonly partial struct MySqlFlexibleServerConfigPendingRestartState : IEquatable<MySqlFlexibleServerConfigPendingRestartState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerConfigPendingRestartState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MySqlFlexibleServerConfigPendingRestartState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrueValue = "True";
        private const string FalseValue = "False";

        /// <summary> True. </summary>
        public static MySqlFlexibleServerConfigPendingRestartState True { get; } = new MySqlFlexibleServerConfigPendingRestartState(TrueValue);
        /// <summary> False. </summary>
        public static MySqlFlexibleServerConfigPendingRestartState False { get; } = new MySqlFlexibleServerConfigPendingRestartState(FalseValue);
        /// <summary> Determines if two <see cref="MySqlFlexibleServerConfigPendingRestartState"/> values are the same. </summary>
        public static bool operator ==(MySqlFlexibleServerConfigPendingRestartState left, MySqlFlexibleServerConfigPendingRestartState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MySqlFlexibleServerConfigPendingRestartState"/> values are not the same. </summary>
        public static bool operator !=(MySqlFlexibleServerConfigPendingRestartState left, MySqlFlexibleServerConfigPendingRestartState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MySqlFlexibleServerConfigPendingRestartState"/>. </summary>
        public static implicit operator MySqlFlexibleServerConfigPendingRestartState(string value) => new MySqlFlexibleServerConfigPendingRestartState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MySqlFlexibleServerConfigPendingRestartState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MySqlFlexibleServerConfigPendingRestartState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
