// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MySql.FlexibleServers.Models
{
    /// <summary> If is the configuration dynamic. </summary>
    public readonly partial struct MySqlFlexibleServerConfigDynamicState : IEquatable<MySqlFlexibleServerConfigDynamicState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerConfigDynamicState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MySqlFlexibleServerConfigDynamicState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrueValue = "True";
        private const string FalseValue = "False";

        /// <summary> True. </summary>
        public static MySqlFlexibleServerConfigDynamicState True { get; } = new MySqlFlexibleServerConfigDynamicState(TrueValue);
        /// <summary> False. </summary>
        public static MySqlFlexibleServerConfigDynamicState False { get; } = new MySqlFlexibleServerConfigDynamicState(FalseValue);
        /// <summary> Determines if two <see cref="MySqlFlexibleServerConfigDynamicState"/> values are the same. </summary>
        public static bool operator ==(MySqlFlexibleServerConfigDynamicState left, MySqlFlexibleServerConfigDynamicState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MySqlFlexibleServerConfigDynamicState"/> values are not the same. </summary>
        public static bool operator !=(MySqlFlexibleServerConfigDynamicState left, MySqlFlexibleServerConfigDynamicState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MySqlFlexibleServerConfigDynamicState"/>. </summary>
        public static implicit operator MySqlFlexibleServerConfigDynamicState(string value) => new MySqlFlexibleServerConfigDynamicState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MySqlFlexibleServerConfigDynamicState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MySqlFlexibleServerConfigDynamicState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
