// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MySql.FlexibleServers.Models
{
    /// <summary> Backup Settings. </summary>
    public partial class MySqlFlexibleServerBackupSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerBackupSettings"/>. </summary>
        /// <param name="backupName"> The name of the backup. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="backupName"/> is null. </exception>
        public MySqlFlexibleServerBackupSettings(string backupName)
        {
            Argument.AssertNotNull(backupName, nameof(backupName));

            BackupName = backupName;
        }

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerBackupSettings"/>. </summary>
        /// <param name="backupName"> The name of the backup. </param>
        /// <param name="backupFormat"> Backup Format for the current backup. (CollatedFormat is INTERNAL – DO NOT USE). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MySqlFlexibleServerBackupSettings(string backupName, MySqlFlexibleServerBackupFormat? backupFormat, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            BackupName = backupName;
            BackupFormat = backupFormat;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerBackupSettings"/> for deserialization. </summary>
        internal MySqlFlexibleServerBackupSettings()
        {
        }

        /// <summary> The name of the backup. </summary>
        public string BackupName { get; }
        /// <summary> Backup Format for the current backup. (CollatedFormat is INTERNAL – DO NOT USE). </summary>
        public MySqlFlexibleServerBackupFormat? BackupFormat { get; set; }
    }
}
