// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MySql.FlexibleServers.Models
{
    /// <summary> The current provisioning state. </summary>
    public readonly partial struct MySqlFlexibleServerBackupProvisioningState : IEquatable<MySqlFlexibleServerBackupProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerBackupProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MySqlFlexibleServerBackupProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string CreatingValue = "Creating";
        private const string DeletingValue = "Deleting";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";

        /// <summary> Succeeded. </summary>
        public static MySqlFlexibleServerBackupProvisioningState Succeeded { get; } = new MySqlFlexibleServerBackupProvisioningState(SucceededValue);
        /// <summary> Creating. </summary>
        public static MySqlFlexibleServerBackupProvisioningState Creating { get; } = new MySqlFlexibleServerBackupProvisioningState(CreatingValue);
        /// <summary> Deleting. </summary>
        public static MySqlFlexibleServerBackupProvisioningState Deleting { get; } = new MySqlFlexibleServerBackupProvisioningState(DeletingValue);
        /// <summary> Failed. </summary>
        public static MySqlFlexibleServerBackupProvisioningState Failed { get; } = new MySqlFlexibleServerBackupProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static MySqlFlexibleServerBackupProvisioningState Canceled { get; } = new MySqlFlexibleServerBackupProvisioningState(CanceledValue);
        /// <summary> Determines if two <see cref="MySqlFlexibleServerBackupProvisioningState"/> values are the same. </summary>
        public static bool operator ==(MySqlFlexibleServerBackupProvisioningState left, MySqlFlexibleServerBackupProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MySqlFlexibleServerBackupProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(MySqlFlexibleServerBackupProvisioningState left, MySqlFlexibleServerBackupProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MySqlFlexibleServerBackupProvisioningState"/>. </summary>
        public static implicit operator MySqlFlexibleServerBackupProvisioningState(string value) => new MySqlFlexibleServerBackupProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MySqlFlexibleServerBackupProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MySqlFlexibleServerBackupProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
