// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MySql.FlexibleServers.Models
{
    /// <summary> Storage Profile properties of a server. </summary>
    public partial class MySqlFlexibleServerBackupProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerBackupProperties"/>. </summary>
        public MySqlFlexibleServerBackupProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerBackupProperties"/>. </summary>
        /// <param name="backupRetentionDays"> Backup retention days for the server. </param>
        /// <param name="backupIntervalHours"> Backup interval hours for the server. </param>
        /// <param name="geoRedundantBackup"> Whether or not geo redundant backup is enabled. </param>
        /// <param name="earliestRestoreOn"> Earliest restore point creation time (ISO8601 format). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MySqlFlexibleServerBackupProperties(int? backupRetentionDays, int? backupIntervalHours, MySqlFlexibleServerEnableStatusEnum? geoRedundantBackup, DateTimeOffset? earliestRestoreOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            BackupRetentionDays = backupRetentionDays;
            BackupIntervalHours = backupIntervalHours;
            GeoRedundantBackup = geoRedundantBackup;
            EarliestRestoreOn = earliestRestoreOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Backup retention days for the server. </summary>
        public int? BackupRetentionDays { get; set; }
        /// <summary> Backup interval hours for the server. </summary>
        public int? BackupIntervalHours { get; set; }
        /// <summary> Whether or not geo redundant backup is enabled. </summary>
        public MySqlFlexibleServerEnableStatusEnum? GeoRedundantBackup { get; set; }
        /// <summary> Earliest restore point creation time (ISO8601 format). </summary>
        public DateTimeOffset? EarliestRestoreOn { get; }
    }
}
