// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.MySql.FlexibleServers.Models
{
    internal static partial class MySqlFlexibleServerBackupAndExportOperationStatusExtensions
    {
        public static string ToSerialString(this MySqlFlexibleServerBackupAndExportOperationStatus value) => value switch
        {
            MySqlFlexibleServerBackupAndExportOperationStatus.Pending => "Pending",
            MySqlFlexibleServerBackupAndExportOperationStatus.InProgress => "InProgress",
            MySqlFlexibleServerBackupAndExportOperationStatus.Succeeded => "Succeeded",
            MySqlFlexibleServerBackupAndExportOperationStatus.Failed => "Failed",
            MySqlFlexibleServerBackupAndExportOperationStatus.CancelInProgress => "CancelInProgress",
            MySqlFlexibleServerBackupAndExportOperationStatus.Canceled => "Canceled",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown MySqlFlexibleServerBackupAndExportOperationStatus value.")
        };

        public static MySqlFlexibleServerBackupAndExportOperationStatus ToMySqlFlexibleServerBackupAndExportOperationStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Pending")) return MySqlFlexibleServerBackupAndExportOperationStatus.Pending;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "InProgress")) return MySqlFlexibleServerBackupAndExportOperationStatus.InProgress;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Succeeded")) return MySqlFlexibleServerBackupAndExportOperationStatus.Succeeded;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Failed")) return MySqlFlexibleServerBackupAndExportOperationStatus.Failed;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "CancelInProgress")) return MySqlFlexibleServerBackupAndExportOperationStatus.CancelInProgress;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Canceled")) return MySqlFlexibleServerBackupAndExportOperationStatus.Canceled;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown MySqlFlexibleServerBackupAndExportOperationStatus value.");
        }
    }
}
