// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MySql.FlexibleServers.Models
{
    /// <summary> Type of the sever administrator. </summary>
    public readonly partial struct MySqlFlexibleServerAdministratorType : IEquatable<MySqlFlexibleServerAdministratorType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerAdministratorType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MySqlFlexibleServerAdministratorType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveDirectoryValue = "ActiveDirectory";

        /// <summary> ActiveDirectory. </summary>
        public static MySqlFlexibleServerAdministratorType ActiveDirectory { get; } = new MySqlFlexibleServerAdministratorType(ActiveDirectoryValue);
        /// <summary> Determines if two <see cref="MySqlFlexibleServerAdministratorType"/> values are the same. </summary>
        public static bool operator ==(MySqlFlexibleServerAdministratorType left, MySqlFlexibleServerAdministratorType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MySqlFlexibleServerAdministratorType"/> values are not the same. </summary>
        public static bool operator !=(MySqlFlexibleServerAdministratorType left, MySqlFlexibleServerAdministratorType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MySqlFlexibleServerAdministratorType"/>. </summary>
        public static implicit operator MySqlFlexibleServerAdministratorType(string value) => new MySqlFlexibleServerAdministratorType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MySqlFlexibleServerAdministratorType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MySqlFlexibleServerAdministratorType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
