// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MySql.FlexibleServers.Models
{
    /// <summary> The MySqlFlexibleServerAdministratorName. </summary>
    public readonly partial struct MySqlFlexibleServerAdministratorName : IEquatable<MySqlFlexibleServerAdministratorName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MySqlFlexibleServerAdministratorName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MySqlFlexibleServerAdministratorName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveDirectoryValue = "ActiveDirectory";

        /// <summary> ActiveDirectory. </summary>
        public static MySqlFlexibleServerAdministratorName ActiveDirectory { get; } = new MySqlFlexibleServerAdministratorName(ActiveDirectoryValue);
        /// <summary> Determines if two <see cref="MySqlFlexibleServerAdministratorName"/> values are the same. </summary>
        public static bool operator ==(MySqlFlexibleServerAdministratorName left, MySqlFlexibleServerAdministratorName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MySqlFlexibleServerAdministratorName"/> values are not the same. </summary>
        public static bool operator !=(MySqlFlexibleServerAdministratorName left, MySqlFlexibleServerAdministratorName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MySqlFlexibleServerAdministratorName"/>. </summary>
        public static implicit operator MySqlFlexibleServerAdministratorName(string value) => new MySqlFlexibleServerAdministratorName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MySqlFlexibleServerAdministratorName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MySqlFlexibleServerAdministratorName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
