// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MySql.FlexibleServers.Models
{
    /// <summary> High availability validation properties of a server. </summary>
    public partial class HighAvailabilityValidationEstimation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HighAvailabilityValidationEstimation"/>. </summary>
        public HighAvailabilityValidationEstimation()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HighAvailabilityValidationEstimation"/>. </summary>
        /// <param name="estimatedDowntime"> Estimated seconds of downtime for the deployment. </param>
        /// <param name="scheduledStandbyAvailabilityZone"> Scheduled Availability zone of the standby server. </param>
        /// <param name="expectedStandbyAvailabilityZone"> Expected Availability zone of the standby server. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HighAvailabilityValidationEstimation(int? estimatedDowntime, string scheduledStandbyAvailabilityZone, string expectedStandbyAvailabilityZone, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            EstimatedDowntime = estimatedDowntime;
            ScheduledStandbyAvailabilityZone = scheduledStandbyAvailabilityZone;
            ExpectedStandbyAvailabilityZone = expectedStandbyAvailabilityZone;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Estimated seconds of downtime for the deployment. </summary>
        public int? EstimatedDowntime { get; }
        /// <summary> Scheduled Availability zone of the standby server. </summary>
        public string ScheduledStandbyAvailabilityZone { get; }
        /// <summary> Expected Availability zone of the standby server. </summary>
        public string ExpectedStandbyAvailabilityZone { get; set; }
    }
}
