// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MySql.FlexibleServers.Models
{
    /// <summary> Specifies the state of the Advanced Threat Protection, whether it is enabled or disabled on the server. </summary>
    public readonly partial struct AdvancedThreatProtectionState : IEquatable<AdvancedThreatProtectionState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AdvancedThreatProtectionState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AdvancedThreatProtectionState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static AdvancedThreatProtectionState Enabled { get; } = new AdvancedThreatProtectionState(EnabledValue);
        /// <summary> Disabled. </summary>
        public static AdvancedThreatProtectionState Disabled { get; } = new AdvancedThreatProtectionState(DisabledValue);
        /// <summary> Determines if two <see cref="AdvancedThreatProtectionState"/> values are the same. </summary>
        public static bool operator ==(AdvancedThreatProtectionState left, AdvancedThreatProtectionState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AdvancedThreatProtectionState"/> values are not the same. </summary>
        public static bool operator !=(AdvancedThreatProtectionState left, AdvancedThreatProtectionState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AdvancedThreatProtectionState"/>. </summary>
        public static implicit operator AdvancedThreatProtectionState(string value) => new AdvancedThreatProtectionState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AdvancedThreatProtectionState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AdvancedThreatProtectionState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
