// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.MySql.FlexibleServers.Models;

namespace Azure.ResourceManager.MySql.FlexibleServers
{
    internal class MySqlFlexibleServerConfigurationsOperationSource : IOperationSource<MySqlFlexibleServerConfigurations>
    {
        MySqlFlexibleServerConfigurations IOperationSource<MySqlFlexibleServerConfigurations>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return MySqlFlexibleServerConfigurations.DeserializeMySqlFlexibleServerConfigurations(document.RootElement);
        }

        async ValueTask<MySqlFlexibleServerConfigurations> IOperationSource<MySqlFlexibleServerConfigurations>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return MySqlFlexibleServerConfigurations.DeserializeMySqlFlexibleServerConfigurations(document.RootElement);
        }
    }
}
