// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MySql.FlexibleServers
{
    internal class MySqlFlexibleServerBackupV2OperationSource : IOperationSource<MySqlFlexibleServerBackupV2Resource>
    {
        private readonly ArmClient _client;

        internal MySqlFlexibleServerBackupV2OperationSource(ArmClient client)
        {
            _client = client;
        }

        MySqlFlexibleServerBackupV2Resource IOperationSource<MySqlFlexibleServerBackupV2Resource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MySqlFlexibleServerBackupV2Data.DeserializeMySqlFlexibleServerBackupV2Data(document.RootElement);
            return new MySqlFlexibleServerBackupV2Resource(_client, data);
        }

        async ValueTask<MySqlFlexibleServerBackupV2Resource> IOperationSource<MySqlFlexibleServerBackupV2Resource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MySqlFlexibleServerBackupV2Data.DeserializeMySqlFlexibleServerBackupV2Data(document.RootElement);
            return new MySqlFlexibleServerBackupV2Resource(_client, data);
        }
    }
}
