// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.MySql.FlexibleServers.Models;

namespace Azure.ResourceManager.MySql.FlexibleServers
{
    /// <summary>
    /// A class representing a collection of <see cref="AdvancedThreatProtectionResource"/> and their operations.
    /// Each <see cref="AdvancedThreatProtectionResource"/> in the collection will belong to the same instance of <see cref="MySqlFlexibleServerResource"/>.
    /// To get an <see cref="AdvancedThreatProtectionCollection"/> instance call the GetAdvancedThreatProtections method from an instance of <see cref="MySqlFlexibleServerResource"/>.
    /// </summary>
    public partial class AdvancedThreatProtectionCollection : ArmCollection, IEnumerable<AdvancedThreatProtectionResource>, IAsyncEnumerable<AdvancedThreatProtectionResource>
    {
        private readonly ClientDiagnostics _advancedThreatProtectionAdvancedThreatProtectionSettingsClientDiagnostics;
        private readonly AdvancedThreatProtectionSettingsRestOperations _advancedThreatProtectionAdvancedThreatProtectionSettingsRestClient;

        /// <summary> Initializes a new instance of the <see cref="AdvancedThreatProtectionCollection"/> class for mocking. </summary>
        protected AdvancedThreatProtectionCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="AdvancedThreatProtectionCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal AdvancedThreatProtectionCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _advancedThreatProtectionAdvancedThreatProtectionSettingsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.MySql.FlexibleServers", AdvancedThreatProtectionResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(AdvancedThreatProtectionResource.ResourceType, out string advancedThreatProtectionAdvancedThreatProtectionSettingsApiVersion);
            _advancedThreatProtectionAdvancedThreatProtectionSettingsRestClient = new AdvancedThreatProtectionSettingsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, advancedThreatProtectionAdvancedThreatProtectionSettingsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != MySqlFlexibleServerResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, MySqlFlexibleServerResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Updates a server's Advanced Threat Protection state.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/flexibleServers/{serverName}/advancedThreatProtectionSettings/{advancedThreatProtectionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AdvancedThreatProtectionSettings_UpdatePut</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-12-30</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AdvancedThreatProtectionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="advancedThreatProtectionName"> The name of the Advanced Threat Protection state. </param>
        /// <param name="data"> The server's Advanced Threat Protection body to update. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<AdvancedThreatProtectionResource>> CreateOrUpdateAsync(WaitUntil waitUntil, AdvancedThreatProtectionName advancedThreatProtectionName, AdvancedThreatProtectionData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _advancedThreatProtectionAdvancedThreatProtectionSettingsClientDiagnostics.CreateScope("AdvancedThreatProtectionCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _advancedThreatProtectionAdvancedThreatProtectionSettingsRestClient.UpdatePutAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, advancedThreatProtectionName, data, cancellationToken).ConfigureAwait(false);
                var operation = new FlexibleServersArmOperation<AdvancedThreatProtectionResource>(new AdvancedThreatProtectionOperationSource(Client), _advancedThreatProtectionAdvancedThreatProtectionSettingsClientDiagnostics, Pipeline, _advancedThreatProtectionAdvancedThreatProtectionSettingsRestClient.CreateUpdatePutRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, advancedThreatProtectionName, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Updates a server's Advanced Threat Protection state.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/flexibleServers/{serverName}/advancedThreatProtectionSettings/{advancedThreatProtectionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AdvancedThreatProtectionSettings_UpdatePut</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-12-30</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AdvancedThreatProtectionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="advancedThreatProtectionName"> The name of the Advanced Threat Protection state. </param>
        /// <param name="data"> The server's Advanced Threat Protection body to update. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<AdvancedThreatProtectionResource> CreateOrUpdate(WaitUntil waitUntil, AdvancedThreatProtectionName advancedThreatProtectionName, AdvancedThreatProtectionData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _advancedThreatProtectionAdvancedThreatProtectionSettingsClientDiagnostics.CreateScope("AdvancedThreatProtectionCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _advancedThreatProtectionAdvancedThreatProtectionSettingsRestClient.UpdatePut(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, advancedThreatProtectionName, data, cancellationToken);
                var operation = new FlexibleServersArmOperation<AdvancedThreatProtectionResource>(new AdvancedThreatProtectionOperationSource(Client), _advancedThreatProtectionAdvancedThreatProtectionSettingsClientDiagnostics, Pipeline, _advancedThreatProtectionAdvancedThreatProtectionSettingsRestClient.CreateUpdatePutRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, advancedThreatProtectionName, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a server's Advanced Threat Protection state
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/flexibleServers/{serverName}/advancedThreatProtectionSettings/{advancedThreatProtectionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AdvancedThreatProtectionSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-12-30</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AdvancedThreatProtectionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="advancedThreatProtectionName"> The name of the Advanced Threat Protection state. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<AdvancedThreatProtectionResource>> GetAsync(AdvancedThreatProtectionName advancedThreatProtectionName, CancellationToken cancellationToken = default)
        {
            using var scope = _advancedThreatProtectionAdvancedThreatProtectionSettingsClientDiagnostics.CreateScope("AdvancedThreatProtectionCollection.Get");
            scope.Start();
            try
            {
                var response = await _advancedThreatProtectionAdvancedThreatProtectionSettingsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, advancedThreatProtectionName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AdvancedThreatProtectionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a server's Advanced Threat Protection state
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/flexibleServers/{serverName}/advancedThreatProtectionSettings/{advancedThreatProtectionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AdvancedThreatProtectionSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-12-30</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AdvancedThreatProtectionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="advancedThreatProtectionName"> The name of the Advanced Threat Protection state. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<AdvancedThreatProtectionResource> Get(AdvancedThreatProtectionName advancedThreatProtectionName, CancellationToken cancellationToken = default)
        {
            using var scope = _advancedThreatProtectionAdvancedThreatProtectionSettingsClientDiagnostics.CreateScope("AdvancedThreatProtectionCollection.Get");
            scope.Start();
            try
            {
                var response = _advancedThreatProtectionAdvancedThreatProtectionSettingsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, advancedThreatProtectionName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AdvancedThreatProtectionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a list of server's Advanced Threat Protection states.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/flexibleServers/{serverName}/advancedThreatProtectionSettings</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AdvancedThreatProtectionSettings_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-12-30</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AdvancedThreatProtectionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="AdvancedThreatProtectionResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<AdvancedThreatProtectionResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _advancedThreatProtectionAdvancedThreatProtectionSettingsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _advancedThreatProtectionAdvancedThreatProtectionSettingsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new AdvancedThreatProtectionResource(Client, AdvancedThreatProtectionData.DeserializeAdvancedThreatProtectionData(e)), _advancedThreatProtectionAdvancedThreatProtectionSettingsClientDiagnostics, Pipeline, "AdvancedThreatProtectionCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets a list of server's Advanced Threat Protection states.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/flexibleServers/{serverName}/advancedThreatProtectionSettings</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AdvancedThreatProtectionSettings_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-12-30</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AdvancedThreatProtectionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="AdvancedThreatProtectionResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<AdvancedThreatProtectionResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _advancedThreatProtectionAdvancedThreatProtectionSettingsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _advancedThreatProtectionAdvancedThreatProtectionSettingsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new AdvancedThreatProtectionResource(Client, AdvancedThreatProtectionData.DeserializeAdvancedThreatProtectionData(e)), _advancedThreatProtectionAdvancedThreatProtectionSettingsClientDiagnostics, Pipeline, "AdvancedThreatProtectionCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/flexibleServers/{serverName}/advancedThreatProtectionSettings/{advancedThreatProtectionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AdvancedThreatProtectionSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-12-30</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AdvancedThreatProtectionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="advancedThreatProtectionName"> The name of the Advanced Threat Protection state. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<bool>> ExistsAsync(AdvancedThreatProtectionName advancedThreatProtectionName, CancellationToken cancellationToken = default)
        {
            using var scope = _advancedThreatProtectionAdvancedThreatProtectionSettingsClientDiagnostics.CreateScope("AdvancedThreatProtectionCollection.Exists");
            scope.Start();
            try
            {
                var response = await _advancedThreatProtectionAdvancedThreatProtectionSettingsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, advancedThreatProtectionName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/flexibleServers/{serverName}/advancedThreatProtectionSettings/{advancedThreatProtectionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AdvancedThreatProtectionSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-12-30</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AdvancedThreatProtectionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="advancedThreatProtectionName"> The name of the Advanced Threat Protection state. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<bool> Exists(AdvancedThreatProtectionName advancedThreatProtectionName, CancellationToken cancellationToken = default)
        {
            using var scope = _advancedThreatProtectionAdvancedThreatProtectionSettingsClientDiagnostics.CreateScope("AdvancedThreatProtectionCollection.Exists");
            scope.Start();
            try
            {
                var response = _advancedThreatProtectionAdvancedThreatProtectionSettingsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, advancedThreatProtectionName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/flexibleServers/{serverName}/advancedThreatProtectionSettings/{advancedThreatProtectionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AdvancedThreatProtectionSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-12-30</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AdvancedThreatProtectionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="advancedThreatProtectionName"> The name of the Advanced Threat Protection state. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<NullableResponse<AdvancedThreatProtectionResource>> GetIfExistsAsync(AdvancedThreatProtectionName advancedThreatProtectionName, CancellationToken cancellationToken = default)
        {
            using var scope = _advancedThreatProtectionAdvancedThreatProtectionSettingsClientDiagnostics.CreateScope("AdvancedThreatProtectionCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _advancedThreatProtectionAdvancedThreatProtectionSettingsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, advancedThreatProtectionName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<AdvancedThreatProtectionResource>(response.GetRawResponse());
                return Response.FromValue(new AdvancedThreatProtectionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/flexibleServers/{serverName}/advancedThreatProtectionSettings/{advancedThreatProtectionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AdvancedThreatProtectionSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-12-30</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AdvancedThreatProtectionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="advancedThreatProtectionName"> The name of the Advanced Threat Protection state. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual NullableResponse<AdvancedThreatProtectionResource> GetIfExists(AdvancedThreatProtectionName advancedThreatProtectionName, CancellationToken cancellationToken = default)
        {
            using var scope = _advancedThreatProtectionAdvancedThreatProtectionSettingsClientDiagnostics.CreateScope("AdvancedThreatProtectionCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _advancedThreatProtectionAdvancedThreatProtectionSettingsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, advancedThreatProtectionName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<AdvancedThreatProtectionResource>(response.GetRawResponse());
                return Response.FromValue(new AdvancedThreatProtectionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<AdvancedThreatProtectionResource> IEnumerable<AdvancedThreatProtectionResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<AdvancedThreatProtectionResource> IAsyncEnumerable<AdvancedThreatProtectionResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
