// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.MySql
{
    public partial class MySqlQueryStatisticData : IUtf8JsonSerializable, IJsonModel<MySqlQueryStatisticData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MySqlQueryStatisticData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MySqlQueryStatisticData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MySqlQueryStatisticData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MySqlQueryStatisticData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(QueryId))
            {
                writer.WritePropertyName("queryId"u8);
                writer.WriteStringValue(QueryId);
            }
            if (Optional.IsDefined(StartOn))
            {
                writer.WritePropertyName("startTime"u8);
                writer.WriteStringValue(StartOn.Value, "O");
            }
            if (Optional.IsDefined(EndOn))
            {
                writer.WritePropertyName("endTime"u8);
                writer.WriteStringValue(EndOn.Value, "O");
            }
            if (Optional.IsDefined(AggregationFunction))
            {
                writer.WritePropertyName("aggregationFunction"u8);
                writer.WriteStringValue(AggregationFunction);
            }
            if (Optional.IsCollectionDefined(DatabaseNames))
            {
                writer.WritePropertyName("databaseNames"u8);
                writer.WriteStartArray();
                foreach (var item in DatabaseNames)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(QueryExecutionCount))
            {
                writer.WritePropertyName("queryExecutionCount"u8);
                writer.WriteNumberValue(QueryExecutionCount.Value);
            }
            if (Optional.IsDefined(MetricName))
            {
                writer.WritePropertyName("metricName"u8);
                writer.WriteStringValue(MetricName);
            }
            if (Optional.IsDefined(MetricDisplayName))
            {
                writer.WritePropertyName("metricDisplayName"u8);
                writer.WriteStringValue(MetricDisplayName);
            }
            if (Optional.IsDefined(MetricValue))
            {
                writer.WritePropertyName("metricValue"u8);
                writer.WriteNumberValue(MetricValue.Value);
            }
            if (Optional.IsDefined(MetricValueUnit))
            {
                writer.WritePropertyName("metricValueUnit"u8);
                writer.WriteStringValue(MetricValueUnit);
            }
            writer.WriteEndObject();
        }

        MySqlQueryStatisticData IJsonModel<MySqlQueryStatisticData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MySqlQueryStatisticData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MySqlQueryStatisticData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMySqlQueryStatisticData(document.RootElement, options);
        }

        internal static MySqlQueryStatisticData DeserializeMySqlQueryStatisticData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string queryId = default;
            DateTimeOffset? startTime = default;
            DateTimeOffset? endTime = default;
            string aggregationFunction = default;
            IList<string> databaseNames = default;
            long? queryExecutionCount = default;
            string metricName = default;
            string metricDisplayName = default;
            double? metricValue = default;
            string metricValueUnit = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("queryId"u8))
                        {
                            queryId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("startTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            startTime = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("endTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            endTime = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("aggregationFunction"u8))
                        {
                            aggregationFunction = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("databaseNames"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            databaseNames = array;
                            continue;
                        }
                        if (property0.NameEquals("queryExecutionCount"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            queryExecutionCount = property0.Value.GetInt64();
                            continue;
                        }
                        if (property0.NameEquals("metricName"u8))
                        {
                            metricName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("metricDisplayName"u8))
                        {
                            metricDisplayName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("metricValue"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            metricValue = property0.Value.GetDouble();
                            continue;
                        }
                        if (property0.NameEquals("metricValueUnit"u8))
                        {
                            metricValueUnit = property0.Value.GetString();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new MySqlQueryStatisticData(
                id,
                name,
                type,
                systemData,
                queryId,
                startTime,
                endTime,
                aggregationFunction,
                databaseNames ?? new ChangeTrackingList<string>(),
                queryExecutionCount,
                metricName,
                metricDisplayName,
                metricValue,
                metricValueUnit,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<MySqlQueryStatisticData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MySqlQueryStatisticData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(MySqlQueryStatisticData)} does not support writing '{options.Format}' format.");
            }
        }

        MySqlQueryStatisticData IPersistableModel<MySqlQueryStatisticData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MySqlQueryStatisticData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMySqlQueryStatisticData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MySqlQueryStatisticData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MySqlQueryStatisticData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
