// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.MySql.Models;

namespace Azure.ResourceManager.MySql
{
    /// <summary>
    /// A class representing a collection of <see cref="MySqlQueryStatisticResource"/> and their operations.
    /// Each <see cref="MySqlQueryStatisticResource"/> in the collection will belong to the same instance of <see cref="MySqlServerResource"/>.
    /// To get a <see cref="MySqlQueryStatisticCollection"/> instance call the GetMySqlQueryStatistics method from an instance of <see cref="MySqlServerResource"/>.
    /// </summary>
    public partial class MySqlQueryStatisticCollection : ArmCollection
    {
        private readonly ClientDiagnostics _mySqlQueryStatisticTopQueryStatisticsClientDiagnostics;
        private readonly TopQueryStatisticsRestOperations _mySqlQueryStatisticTopQueryStatisticsRestClient;

        /// <summary> Initializes a new instance of the <see cref="MySqlQueryStatisticCollection"/> class for mocking. </summary>
        protected MySqlQueryStatisticCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MySqlQueryStatisticCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal MySqlQueryStatisticCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _mySqlQueryStatisticTopQueryStatisticsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.MySql", MySqlQueryStatisticResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(MySqlQueryStatisticResource.ResourceType, out string mySqlQueryStatisticTopQueryStatisticsApiVersion);
            _mySqlQueryStatisticTopQueryStatisticsRestClient = new TopQueryStatisticsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, mySqlQueryStatisticTopQueryStatisticsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != MySqlServerResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, MySqlServerResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Retrieve the query statistic for specified identifier.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}/topQueryStatistics/{queryStatisticId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>TopQueryStatistics_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MySqlQueryStatisticResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="queryStatisticId"> The Query Statistic identifier. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="queryStatisticId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="queryStatisticId"/> is null. </exception>
        public virtual async Task<Response<MySqlQueryStatisticResource>> GetAsync(string queryStatisticId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(queryStatisticId, nameof(queryStatisticId));

            using var scope = _mySqlQueryStatisticTopQueryStatisticsClientDiagnostics.CreateScope("MySqlQueryStatisticCollection.Get");
            scope.Start();
            try
            {
                var response = await _mySqlQueryStatisticTopQueryStatisticsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, queryStatisticId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new MySqlQueryStatisticResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Retrieve the query statistic for specified identifier.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}/topQueryStatistics/{queryStatisticId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>TopQueryStatistics_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MySqlQueryStatisticResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="queryStatisticId"> The Query Statistic identifier. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="queryStatisticId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="queryStatisticId"/> is null. </exception>
        public virtual Response<MySqlQueryStatisticResource> Get(string queryStatisticId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(queryStatisticId, nameof(queryStatisticId));

            using var scope = _mySqlQueryStatisticTopQueryStatisticsClientDiagnostics.CreateScope("MySqlQueryStatisticCollection.Get");
            scope.Start();
            try
            {
                var response = _mySqlQueryStatisticTopQueryStatisticsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, queryStatisticId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new MySqlQueryStatisticResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Retrieve the Query-Store top queries for specified metric and aggregation.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}/topQueryStatistics</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>TopQueryStatistics_ListByServer</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MySqlQueryStatisticResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="input"> The required parameters for retrieving top query statistics. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="input"/> is null. </exception>
        /// <returns> An async collection of <see cref="MySqlQueryStatisticResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<MySqlQueryStatisticResource> GetAllAsync(MySqlTopQueryStatisticsInput input, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(input, nameof(input));

            HttpMessage FirstPageRequest(int? pageSizeHint) => _mySqlQueryStatisticTopQueryStatisticsRestClient.CreateListByServerRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, input);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _mySqlQueryStatisticTopQueryStatisticsRestClient.CreateListByServerNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, input);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new MySqlQueryStatisticResource(Client, MySqlQueryStatisticData.DeserializeMySqlQueryStatisticData(e)), _mySqlQueryStatisticTopQueryStatisticsClientDiagnostics, Pipeline, "MySqlQueryStatisticCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Retrieve the Query-Store top queries for specified metric and aggregation.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}/topQueryStatistics</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>TopQueryStatistics_ListByServer</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MySqlQueryStatisticResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="input"> The required parameters for retrieving top query statistics. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="input"/> is null. </exception>
        /// <returns> A collection of <see cref="MySqlQueryStatisticResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<MySqlQueryStatisticResource> GetAll(MySqlTopQueryStatisticsInput input, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(input, nameof(input));

            HttpMessage FirstPageRequest(int? pageSizeHint) => _mySqlQueryStatisticTopQueryStatisticsRestClient.CreateListByServerRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, input);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _mySqlQueryStatisticTopQueryStatisticsRestClient.CreateListByServerNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, input);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new MySqlQueryStatisticResource(Client, MySqlQueryStatisticData.DeserializeMySqlQueryStatisticData(e)), _mySqlQueryStatisticTopQueryStatisticsClientDiagnostics, Pipeline, "MySqlQueryStatisticCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}/topQueryStatistics/{queryStatisticId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>TopQueryStatistics_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MySqlQueryStatisticResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="queryStatisticId"> The Query Statistic identifier. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="queryStatisticId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="queryStatisticId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string queryStatisticId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(queryStatisticId, nameof(queryStatisticId));

            using var scope = _mySqlQueryStatisticTopQueryStatisticsClientDiagnostics.CreateScope("MySqlQueryStatisticCollection.Exists");
            scope.Start();
            try
            {
                var response = await _mySqlQueryStatisticTopQueryStatisticsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, queryStatisticId, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}/topQueryStatistics/{queryStatisticId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>TopQueryStatistics_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MySqlQueryStatisticResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="queryStatisticId"> The Query Statistic identifier. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="queryStatisticId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="queryStatisticId"/> is null. </exception>
        public virtual Response<bool> Exists(string queryStatisticId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(queryStatisticId, nameof(queryStatisticId));

            using var scope = _mySqlQueryStatisticTopQueryStatisticsClientDiagnostics.CreateScope("MySqlQueryStatisticCollection.Exists");
            scope.Start();
            try
            {
                var response = _mySqlQueryStatisticTopQueryStatisticsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, queryStatisticId, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}/topQueryStatistics/{queryStatisticId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>TopQueryStatistics_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MySqlQueryStatisticResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="queryStatisticId"> The Query Statistic identifier. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="queryStatisticId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="queryStatisticId"/> is null. </exception>
        public virtual async Task<NullableResponse<MySqlQueryStatisticResource>> GetIfExistsAsync(string queryStatisticId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(queryStatisticId, nameof(queryStatisticId));

            using var scope = _mySqlQueryStatisticTopQueryStatisticsClientDiagnostics.CreateScope("MySqlQueryStatisticCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _mySqlQueryStatisticTopQueryStatisticsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, queryStatisticId, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<MySqlQueryStatisticResource>(response.GetRawResponse());
                return Response.FromValue(new MySqlQueryStatisticResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}/topQueryStatistics/{queryStatisticId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>TopQueryStatistics_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MySqlQueryStatisticResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="queryStatisticId"> The Query Statistic identifier. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="queryStatisticId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="queryStatisticId"/> is null. </exception>
        public virtual NullableResponse<MySqlQueryStatisticResource> GetIfExists(string queryStatisticId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(queryStatisticId, nameof(queryStatisticId));

            using var scope = _mySqlQueryStatisticTopQueryStatisticsClientDiagnostics.CreateScope("MySqlQueryStatisticCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _mySqlQueryStatisticTopQueryStatisticsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, queryStatisticId, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<MySqlQueryStatisticResource>(response.GetRawResponse());
                return Response.FromValue(new MySqlQueryStatisticResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
