// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MySql
{
    internal class MySqlPrivateEndpointConnectionOperationSource : IOperationSource<MySqlPrivateEndpointConnectionResource>
    {
        private readonly ArmClient _client;

        internal MySqlPrivateEndpointConnectionOperationSource(ArmClient client)
        {
            _client = client;
        }

        MySqlPrivateEndpointConnectionResource IOperationSource<MySqlPrivateEndpointConnectionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MySqlPrivateEndpointConnectionData.DeserializeMySqlPrivateEndpointConnectionData(document.RootElement);
            return new MySqlPrivateEndpointConnectionResource(_client, data);
        }

        async ValueTask<MySqlPrivateEndpointConnectionResource> IOperationSource<MySqlPrivateEndpointConnectionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MySqlPrivateEndpointConnectionData.DeserializeMySqlPrivateEndpointConnectionData(document.RootElement);
            return new MySqlPrivateEndpointConnectionResource(_client, data);
        }
    }
}
