// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MySql
{
    internal class MySqlDatabaseOperationSource : IOperationSource<MySqlDatabaseResource>
    {
        private readonly ArmClient _client;

        internal MySqlDatabaseOperationSource(ArmClient client)
        {
            _client = client;
        }

        MySqlDatabaseResource IOperationSource<MySqlDatabaseResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MySqlDatabaseData.DeserializeMySqlDatabaseData(document.RootElement);
            return new MySqlDatabaseResource(_client, data);
        }

        async ValueTask<MySqlDatabaseResource> IOperationSource<MySqlDatabaseResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MySqlDatabaseData.DeserializeMySqlDatabaseData(document.RootElement);
            return new MySqlDatabaseResource(_client, data);
        }
    }
}
