// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.MySql.Models;

namespace Azure.ResourceManager.MySql.Samples
{
    public partial class Sample_MySqlServerSecurityAlertPolicyResource
    {
        // Get a server's threat detection policy
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAServerSThreatDetectionPolicy()
        {
            // Generated from example definition: specification/mysql/resource-manager/Microsoft.DBforMySQL/legacy/stable/2017-12-01/examples/ServerSecurityAlertsGet.json
            // this example is just showing the usage of "ServerSecurityAlertPolicies_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MySqlServerSecurityAlertPolicyResource created on azure
            // for more information of creating MySqlServerSecurityAlertPolicyResource, please refer to the document of MySqlServerSecurityAlertPolicyResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "securityalert-4799";
            string serverName = "securityalert-6440";
            MySqlSecurityAlertPolicyName securityAlertPolicyName = MySqlSecurityAlertPolicyName.Default;
            ResourceIdentifier mySqlServerSecurityAlertPolicyResourceId = MySqlServerSecurityAlertPolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, securityAlertPolicyName);
            MySqlServerSecurityAlertPolicyResource mySqlServerSecurityAlertPolicy = client.GetMySqlServerSecurityAlertPolicyResource(mySqlServerSecurityAlertPolicyResourceId);

            // invoke the operation
            MySqlServerSecurityAlertPolicyResource result = await mySqlServerSecurityAlertPolicy.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MySqlServerSecurityAlertPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update a server's threat detection policy with all parameters
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAServerSThreatDetectionPolicyWithAllParameters()
        {
            // Generated from example definition: specification/mysql/resource-manager/Microsoft.DBforMySQL/legacy/stable/2017-12-01/examples/ServerSecurityAlertsCreateMax.json
            // this example is just showing the usage of "ServerSecurityAlertPolicies_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MySqlServerSecurityAlertPolicyResource created on azure
            // for more information of creating MySqlServerSecurityAlertPolicyResource, please refer to the document of MySqlServerSecurityAlertPolicyResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "securityalert-4799";
            string serverName = "securityalert-6440";
            MySqlSecurityAlertPolicyName securityAlertPolicyName = MySqlSecurityAlertPolicyName.Default;
            ResourceIdentifier mySqlServerSecurityAlertPolicyResourceId = MySqlServerSecurityAlertPolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, securityAlertPolicyName);
            MySqlServerSecurityAlertPolicyResource mySqlServerSecurityAlertPolicy = client.GetMySqlServerSecurityAlertPolicyResource(mySqlServerSecurityAlertPolicyResourceId);

            // invoke the operation
            MySqlServerSecurityAlertPolicyData data = new MySqlServerSecurityAlertPolicyData()
            {
                State = MySqlServerSecurityAlertPolicyState.Enabled,
                DisabledAlerts =
{
"Access_Anomaly","Usage_Anomaly"
},
                EmailAddresses =
{
"testSecurityAlert@microsoft.com"
},
                SendToEmailAccountAdmins = true,
                StorageEndpoint = "https://mystorage.blob.core.windows.net",
                StorageAccountAccessKey = "sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD==",
                RetentionDays = 5,
            };
            ArmOperation<MySqlServerSecurityAlertPolicyResource> lro = await mySqlServerSecurityAlertPolicy.UpdateAsync(WaitUntil.Completed, data);
            MySqlServerSecurityAlertPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MySqlServerSecurityAlertPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update a server's threat detection policy with minimal parameters
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAServerSThreatDetectionPolicyWithMinimalParameters()
        {
            // Generated from example definition: specification/mysql/resource-manager/Microsoft.DBforMySQL/legacy/stable/2017-12-01/examples/ServerSecurityAlertsCreateMin.json
            // this example is just showing the usage of "ServerSecurityAlertPolicies_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MySqlServerSecurityAlertPolicyResource created on azure
            // for more information of creating MySqlServerSecurityAlertPolicyResource, please refer to the document of MySqlServerSecurityAlertPolicyResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "securityalert-4799";
            string serverName = "securityalert-6440";
            MySqlSecurityAlertPolicyName securityAlertPolicyName = MySqlSecurityAlertPolicyName.Default;
            ResourceIdentifier mySqlServerSecurityAlertPolicyResourceId = MySqlServerSecurityAlertPolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, securityAlertPolicyName);
            MySqlServerSecurityAlertPolicyResource mySqlServerSecurityAlertPolicy = client.GetMySqlServerSecurityAlertPolicyResource(mySqlServerSecurityAlertPolicyResourceId);

            // invoke the operation
            MySqlServerSecurityAlertPolicyData data = new MySqlServerSecurityAlertPolicyData()
            {
                State = MySqlServerSecurityAlertPolicyState.Disabled,
                SendToEmailAccountAdmins = true,
            };
            ArmOperation<MySqlServerSecurityAlertPolicyResource> lro = await mySqlServerSecurityAlertPolicy.UpdateAsync(WaitUntil.Completed, data);
            MySqlServerSecurityAlertPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MySqlServerSecurityAlertPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
