// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.MySql.Models;

namespace Azure.ResourceManager.MySql.Samples
{
    public partial class Sample_MySqlServerKeyResource
    {
        // Get the MySQL Server key
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetTheMySQLServerKey()
        {
            // Generated from example definition: specification/mysql/resource-manager/Microsoft.DBforMySQL/legacy/stable/2020-01-01/examples/ServerKeyGet.json
            // this example is just showing the usage of "ServerKeys_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MySqlServerKeyResource created on azure
            // for more information of creating MySqlServerKeyResource, please refer to the document of MySqlServerKeyResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "testrg";
            string serverName = "testserver";
            string keyName = "someVault_someKey_01234567890123456789012345678901";
            ResourceIdentifier mySqlServerKeyResourceId = MySqlServerKeyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, keyName);
            MySqlServerKeyResource mySqlServerKey = client.GetMySqlServerKeyResource(mySqlServerKeyResourceId);

            // invoke the operation
            MySqlServerKeyResource result = await mySqlServerKey.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MySqlServerKeyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Creates or updates a MySQL Server key
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreatesOrUpdatesAMySQLServerKey()
        {
            // Generated from example definition: specification/mysql/resource-manager/Microsoft.DBforMySQL/legacy/stable/2020-01-01/examples/ServerKeyCreateOrUpdate.json
            // this example is just showing the usage of "ServerKeys_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MySqlServerKeyResource created on azure
            // for more information of creating MySqlServerKeyResource, please refer to the document of MySqlServerKeyResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "testrg";
            string serverName = "testserver";
            string keyName = "someVault_someKey_01234567890123456789012345678901";
            ResourceIdentifier mySqlServerKeyResourceId = MySqlServerKeyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, keyName);
            MySqlServerKeyResource mySqlServerKey = client.GetMySqlServerKeyResource(mySqlServerKeyResourceId);

            // invoke the operation
            MySqlServerKeyData data = new MySqlServerKeyData()
            {
                ServerKeyType = MySqlServerKeyType.AzureKeyVault,
                Uri = new Uri("https://someVault.vault.azure.net/keys/someKey/01234567890123456789012345678901"),
            };
            ArmOperation<MySqlServerKeyResource> lro = await mySqlServerKey.UpdateAsync(WaitUntil.Completed, data);
            MySqlServerKeyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MySqlServerKeyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete the MySQL Server key
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteTheMySQLServerKey()
        {
            // Generated from example definition: specification/mysql/resource-manager/Microsoft.DBforMySQL/legacy/stable/2020-01-01/examples/ServerKeyDelete.json
            // this example is just showing the usage of "ServerKeys_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MySqlServerKeyResource created on azure
            // for more information of creating MySqlServerKeyResource, please refer to the document of MySqlServerKeyResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "testrg";
            string serverName = "testserver";
            string keyName = "someVault_someKey_01234567890123456789012345678901";
            ResourceIdentifier mySqlServerKeyResourceId = MySqlServerKeyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, keyName);
            MySqlServerKeyResource mySqlServerKey = client.GetMySqlServerKeyResource(mySqlServerKeyResourceId);

            // invoke the operation
            await mySqlServerKey.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
