// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.MySql.Samples
{
    public partial class Sample_MySqlQueryTextResource
    {
        // QueryTextsGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_QueryTextsGet()
        {
            // Generated from example definition: specification/mysql/resource-manager/Microsoft.DBforMySQL/legacy/stable/2018-06-01/examples/QueryTextsGet.json
            // this example is just showing the usage of "QueryTexts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MySqlQueryTextResource created on azure
            // for more information of creating MySqlQueryTextResource, please refer to the document of MySqlQueryTextResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "testResourceGroupName";
            string serverName = "testServerName";
            string queryId = "1";
            ResourceIdentifier mySqlQueryTextResourceId = MySqlQueryTextResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, queryId);
            MySqlQueryTextResource mySqlQueryText = client.GetMySqlQueryTextResource(mySqlQueryTextResourceId);

            // invoke the operation
            MySqlQueryTextResource result = await mySqlQueryText.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MySqlQueryTextData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
