// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.MySql.FlexibleServers.Models;

namespace Azure.ResourceManager.MySql.FlexibleServers.Samples
{
    public partial class Sample_MySqlFlexibleServerMaintenanceResource
    {
        // Read a maintenance
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ReadAMaintenance()
        {
            // Generated from example definition: specification/mysql/resource-manager/Microsoft.DBforMySQL/Maintenance/stable/2023-12-30/examples/MaintenanceRead.json
            // this example is just showing the usage of "Maintenances_Read" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MySqlFlexibleServerMaintenanceResource created on azure
            // for more information of creating MySqlFlexibleServerMaintenanceResource, please refer to the document of MySqlFlexibleServerMaintenanceResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "TestGroup";
            string serverName = "testserver";
            string maintenanceName = "_T9Q-TS8";
            ResourceIdentifier mySqlFlexibleServerMaintenanceResourceId = MySqlFlexibleServerMaintenanceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, maintenanceName);
            MySqlFlexibleServerMaintenanceResource mySqlFlexibleServerMaintenance = client.GetMySqlFlexibleServerMaintenanceResource(mySqlFlexibleServerMaintenanceResourceId);

            // invoke the operation
            MySqlFlexibleServerMaintenanceResource result = await mySqlFlexibleServerMaintenance.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MySqlFlexibleServerMaintenanceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update maintenance on a server
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateMaintenanceOnAServer()
        {
            // Generated from example definition: specification/mysql/resource-manager/Microsoft.DBforMySQL/Maintenance/stable/2023-12-30/examples/MaintenanceUpdate.json
            // this example is just showing the usage of "Maintenances_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MySqlFlexibleServerMaintenanceResource created on azure
            // for more information of creating MySqlFlexibleServerMaintenanceResource, please refer to the document of MySqlFlexibleServerMaintenanceResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "TestGroup";
            string serverName = "testserver";
            string maintenanceName = "_T9Q-TS8";
            ResourceIdentifier mySqlFlexibleServerMaintenanceResourceId = MySqlFlexibleServerMaintenanceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, maintenanceName);
            MySqlFlexibleServerMaintenanceResource mySqlFlexibleServerMaintenance = client.GetMySqlFlexibleServerMaintenanceResource(mySqlFlexibleServerMaintenanceResourceId);

            // invoke the operation
            MySqlFlexibleServerMaintenancePatch patch = new MySqlFlexibleServerMaintenancePatch()
            {
                MaintenanceStartOn = DateTimeOffset.Parse("2024-01-20T00:00:00"),
            };
            ArmOperation<MySqlFlexibleServerMaintenanceResource> lro = await mySqlFlexibleServerMaintenance.UpdateAsync(WaitUntil.Completed, patch);
            MySqlFlexibleServerMaintenanceResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MySqlFlexibleServerMaintenanceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
