// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Monitor.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Monitor
{
    /// <summary>
    /// A class representing the PipelineGroup data model.
    /// A pipeline group definition.
    /// </summary>
    public partial class PipelineGroupData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PipelineGroupData"/>. </summary>
        /// <param name="location"> The location. </param>
        public PipelineGroupData(AzureLocation location) : base(location)
        {
            Receivers = new ChangeTrackingList<PipelineGroupReceiver>();
            Processors = new ChangeTrackingList<PipelineGroupProcessor>();
            Exporters = new ChangeTrackingList<PipelineGroupExporter>();
            NetworkingConfigurations = new ChangeTrackingList<PipelineGroupNetworkingConfiguration>();
        }

        /// <summary> Initializes a new instance of <see cref="PipelineGroupData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="extendedLocation"> The extended location for given pipeline group. </param>
        /// <param name="replicas"> Defines the amount of replicas of the pipeline group instance. </param>
        /// <param name="receivers"> The receivers specified for a pipeline group instance. </param>
        /// <param name="processors"> The processors specified for a pipeline group instance. </param>
        /// <param name="exporters"> The exporters specified for a pipeline group instance. </param>
        /// <param name="service"> The service section for a given pipeline group instance. </param>
        /// <param name="networkingConfigurations"> Networking configurations for the pipeline group instance. </param>
        /// <param name="provisioningState"> The provisioning state of a pipeline group instance. Set to Succeeded if everything is healthy. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PipelineGroupData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, ExtendedLocation extendedLocation, int? replicas, IList<PipelineGroupReceiver> receivers, IList<PipelineGroupProcessor> processors, IList<PipelineGroupExporter> exporters, PipelineGroupService service, IList<PipelineGroupNetworkingConfiguration> networkingConfigurations, MonitorProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            ExtendedLocation = extendedLocation;
            Replicas = replicas;
            Receivers = receivers;
            Processors = processors;
            Exporters = exporters;
            Service = service;
            NetworkingConfigurations = networkingConfigurations;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="PipelineGroupData"/> for deserialization. </summary>
        internal PipelineGroupData()
        {
        }

        /// <summary> The extended location for given pipeline group. </summary>
        public ExtendedLocation ExtendedLocation { get; set; }
        /// <summary> Defines the amount of replicas of the pipeline group instance. </summary>
        public int? Replicas { get; set; }
        /// <summary> The receivers specified for a pipeline group instance. </summary>
        public IList<PipelineGroupReceiver> Receivers { get; }
        /// <summary> The processors specified for a pipeline group instance. </summary>
        public IList<PipelineGroupProcessor> Processors { get; }
        /// <summary> The exporters specified for a pipeline group instance. </summary>
        public IList<PipelineGroupExporter> Exporters { get; }
        /// <summary> The service section for a given pipeline group instance. </summary>
        public PipelineGroupService Service { get; set; }
        /// <summary> Networking configurations for the pipeline group instance. </summary>
        public IList<PipelineGroupNetworkingConfiguration> NetworkingConfigurations { get; }
        /// <summary> The provisioning state of a pipeline group instance. Set to Succeeded if everything is healthy. </summary>
        public MonitorProvisioningState? ProvisioningState { get; }
    }
}
